/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.request;

import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.admin.indices.refresh.RefreshAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.es.EsClient;

public class ProxyRefreshRequestBuilder
extends RefreshRequestBuilder {
    public ProxyRefreshRequestBuilder(Client client) {
        super((ElasticsearchClient)client.admin().indices(), RefreshAction.INSTANCE);
    }

    public RefreshResponse get() {
        Profiler profiler = Profiler.createIfTrace((Logger)EsClient.LOGGER).start();
        try {
            RefreshResponse refreshResponse = (RefreshResponse)super.execute().actionGet();
            return refreshResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to execute %s", this.toString()), e);
        }
        finally {
            if (profiler.isTraceEnabled()) {
                profiler.stopTrace(this.toString());
            }
        }
    }

    public RefreshResponse get(TimeValue timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public RefreshResponse get(String timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ListenableActionFuture<RefreshResponse> execute() {
        throw new UnsupportedOperationException("execute() should not be called as it's used for asynchronous");
    }

    public String toString() {
        StringBuilder message = new StringBuilder();
        message.append("ES refresh request");
        if (((RefreshRequest)this.request).indices().length > 0) {
            message.append(String.format(" on indices '%s'", StringUtils.join((Object[])((RefreshRequest)this.request).indices(), (String)",")));
        }
        return message.toString();
    }
}

