/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.request;

import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.delete.DeleteAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.es.EsClient;

public class ProxyDeleteRequestBuilder
extends DeleteRequestBuilder {
    public ProxyDeleteRequestBuilder(Client client, String index) {
        super((ElasticsearchClient)client, DeleteAction.INSTANCE, index);
    }

    public DeleteResponse get() {
        Profiler profiler = Profiler.createIfTrace((Logger)EsClient.LOGGER).start();
        try {
            DeleteResponse deleteResponse = (DeleteResponse)super.execute().actionGet();
            return deleteResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to execute %s", this.toString()), e);
        }
        finally {
            if (profiler.isTraceEnabled()) {
                profiler.stopTrace(this.toString());
            }
        }
    }

    public DeleteResponse get(TimeValue timeout) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public DeleteResponse get(String timeout) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ListenableActionFuture<DeleteResponse> execute() {
        throw new UnsupportedOperationException("execute() should not be called as it's used for asynchronous");
    }

    public String toString() {
        StringBuilder message = new StringBuilder();
        message.append("ES delete request of doc ").append(((DeleteRequest)this.request).id()).append(" in index ").append(((DeleteRequest)this.request).index()).append("/").append(((DeleteRequest)this.request).type());
        return message.toString();
    }
}

