/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import java.util.concurrent.atomic.AtomicLong;

public class IndexingResult {
    final AtomicLong total = new AtomicLong(0L);
    private final AtomicLong successes = new AtomicLong(0L);

    IndexingResult clear() {
        this.total.set(0L);
        this.successes.set(0L);
        return this;
    }

    public void incrementRequests() {
        this.total.incrementAndGet();
    }

    public IndexingResult incrementSuccess() {
        this.successes.incrementAndGet();
        return this;
    }

    public void add(IndexingResult other) {
        this.total.addAndGet(other.total.get());
        this.successes.addAndGet(other.successes.get());
    }

    public long getFailures() {
        return this.total.get() - this.successes.get();
    }

    public long getTotal() {
        return this.total.get();
    }

    public long getSuccess() {
        return this.successes.get();
    }

    public double getSuccessRatio() {
        return this.total.get() == 0L ? 1.0 : 1.0 * (double)this.successes.get() / (double)this.total.get();
    }

    public boolean isSuccess() {
        return this.total.get() == this.successes.get();
    }
}

