/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import org.sonar.api.utils.MessageException;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.analysis.Organization;
import org.sonar.server.computation.task.step.ComputationStep;
import org.sonar.server.organization.BillingValidations;
import org.sonar.server.organization.BillingValidationsProxy;

public class VerifyBillingStep
implements ComputationStep {
    private final AnalysisMetadataHolder analysisMetadata;
    private final BillingValidations billingValidations;

    public VerifyBillingStep(AnalysisMetadataHolder analysisMetadata, BillingValidationsProxy billingValidations) {
        this.analysisMetadata = analysisMetadata;
        this.billingValidations = billingValidations;
    }

    @Override
    public void execute() {
        try {
            Organization organization = this.analysisMetadata.getOrganization();
            BillingValidations.Organization billingOrganization = new BillingValidations.Organization(organization.getKey(), organization.getUuid());
            this.billingValidations.checkOnProjectAnalysis(billingOrganization);
        }
        catch (BillingValidations.BillingValidationsException e) {
            throw MessageException.of((String)e.getMessage());
        }
    }

    @Override
    public String getDescription() {
        return "Verify billing";
    }
}

