/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.util.CloseableIterator;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.issue.IssueChangeMapper;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.issue.IssueMapper;
import org.sonar.server.computation.task.projectanalysis.issue.IssueCache;
import org.sonar.server.computation.task.projectanalysis.issue.RuleRepository;
import org.sonar.server.computation.task.projectanalysis.issue.UpdateConflictResolver;
import org.sonar.server.computation.task.step.ComputationStep;
import org.sonar.server.issue.IssueStorage;

public class PersistIssuesStep
implements ComputationStep {
    private final DbClient dbClient;
    private final System2 system2;
    private final UpdateConflictResolver conflictResolver;
    private final RuleRepository ruleRepository;
    private final IssueCache issueCache;

    public PersistIssuesStep(DbClient dbClient, System2 system2, UpdateConflictResolver conflictResolver, RuleRepository ruleRepository, IssueCache issueCache) {
        this.dbClient = dbClient;
        this.system2 = system2;
        this.conflictResolver = conflictResolver;
        this.ruleRepository = ruleRepository;
        this.issueCache = issueCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        IssueStatistics statistics = new IssueStatistics();
        try (DbSession dbSession = this.dbClient.openSession(true);
             CloseableIterator issues = this.issueCache.traverse();){
            IssueMapper mapper = (IssueMapper)dbSession.getMapper(IssueMapper.class);
            IssueChangeMapper changeMapper = (IssueChangeMapper)dbSession.getMapper(IssueChangeMapper.class);
            while (issues.hasNext()) {
                DefaultIssue issue = (DefaultIssue)issues.next();
                boolean saved = this.persistIssueIfRequired(mapper, issue, statistics);
                if (!saved) continue;
                IssueStorage.insertChanges(changeMapper, issue);
            }
            dbSession.flushStatements();
            dbSession.commit();
        }
        finally {
            statistics.log();
        }
    }

    private boolean persistIssueIfRequired(IssueMapper mapper, DefaultIssue issue, IssueStatistics statistics) {
        if (issue.isNew() || issue.isCopied()) {
            this.persistNewIssue(mapper, issue);
            statistics.inserts++;
            return true;
        }
        if (issue.isChanged()) {
            this.persistChangedIssue(mapper, issue);
            statistics.updates++;
            return true;
        }
        statistics.untouched++;
        return false;
    }

    private void persistNewIssue(IssueMapper mapper, DefaultIssue issue) {
        Integer ruleId = this.ruleRepository.getByKey(issue.ruleKey()).getId();
        IssueDto dto = IssueDto.toDtoForComputationInsert((DefaultIssue)issue, (int)ruleId, (long)this.system2.now());
        mapper.insert(dto);
    }

    private void persistChangedIssue(IssueMapper mapper, DefaultIssue issue) {
        IssueDto dto = IssueDto.toDtoForUpdate((DefaultIssue)issue, (long)this.system2.now());
        int updateCount = mapper.updateIfBeforeSelectedDate(dto);
        if (updateCount == 0) {
            this.conflictResolver.resolve(issue, mapper);
        }
    }

    @Override
    public String getDescription() {
        return "Persist issues";
    }

    private static class IssueStatistics {
        private int inserts = 0;
        private int updates = 0;
        private int untouched = 0;

        private IssueStatistics() {
        }

        private void log() {
            Loggers.get(PersistIssuesStep.class).debug("inserts={} | updates={} | untouched={}", new Object[]{this.inserts, this.updates, this.untouched});
        }
    }
}

