/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.source;

import com.google.common.base.Optional;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareVisitor;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfo;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfoRepository;

public class LastCommitVisitor
extends PathAwareVisitorAdapter<LastCommit> {
    private final MeasureRepository measureRepository;
    private final ScmInfoRepository scmInfoRepository;
    private final Metric lastCommitDateMetric;

    public LastCommitVisitor(MetricRepository metricRepository, MeasureRepository measureRepository, ScmInfoRepository scmInfoRepository) {
        super(CrawlerDepthLimit.LEAVES, ComponentVisitor.Order.POST_ORDER, new PathAwareVisitorAdapter.SimpleStackElementFactory<LastCommit>(){

            @Override
            public LastCommit createForAny(Component component) {
                return new LastCommit();
            }

            @Override
            public LastCommit createForProjectView(Component projectView) {
                return null;
            }
        });
        this.measureRepository = measureRepository;
        this.scmInfoRepository = scmInfoRepository;
        this.lastCommitDateMetric = metricRepository.getByKey("last_commit_date");
    }

    @Override
    public void visitProject(Component project, PathAwareVisitor.Path<LastCommit> path) {
        this.saveAndAggregate(project, path);
    }

    @Override
    public void visitDirectory(Component directory, PathAwareVisitor.Path<LastCommit> path) {
        this.saveAndAggregate(directory, path);
    }

    @Override
    public void visitModule(Component module, PathAwareVisitor.Path<LastCommit> path) {
        this.saveAndAggregate(module, path);
    }

    @Override
    public void visitFile(Component file, PathAwareVisitor.Path<LastCommit> path) {
        Optional<ScmInfo> scmInfoOptional = this.scmInfoRepository.getScmInfo(file);
        if (scmInfoOptional.isPresent()) {
            ScmInfo scmInfo = (ScmInfo)scmInfoOptional.get();
            path.current().addDate(scmInfo.getLatestChangeset().getDate());
        }
        this.saveAndAggregate(file, path);
    }

    @Override
    public void visitView(Component view, PathAwareVisitor.Path<LastCommit> path) {
        this.saveAndAggregate(view, path);
    }

    @Override
    public void visitSubView(Component subView, PathAwareVisitor.Path<LastCommit> path) {
        this.saveAndAggregate(subView, path);
    }

    @Override
    public void visitProjectView(Component projectView, PathAwareVisitor.Path<LastCommit> path) {
        Optional<Measure> rawMeasure = this.measureRepository.getRawMeasure(projectView, this.lastCommitDateMetric);
        if (rawMeasure.isPresent()) {
            path.parent().addDate(((Measure)rawMeasure.get()).getLongValue());
        }
    }

    private void saveAndAggregate(Component component, PathAwareVisitor.Path<LastCommit> path) {
        long maxDate = path.current().getDate();
        if (maxDate > 0L) {
            this.measureRepository.add(component, this.lastCommitDateMetric, Measure.newMeasureBuilder().create(maxDate));
            if (!path.isRoot()) {
                path.parent().addDate(maxDate);
            }
        }
    }

    public static final class LastCommit {
        private long date = 0L;

        public void addDate(long l) {
            this.date = Math.max(this.date, l);
        }

        public long getDate() {
            return this.date;
        }
    }
}

