/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.source;

import com.google.common.base.Joiner;
import java.util.Iterator;
import java.util.List;
import org.sonar.core.hash.SourceHashComputer;
import org.sonar.core.hash.SourceLinesHashesComputer;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.server.computation.task.projectanalysis.source.LineReader;

public class ComputeFileSourceData {
    private final List<LineReader> lineReaders;
    private final Iterator<String> linesIterator;
    private final int numberOfLines;
    private int currentLine;

    public ComputeFileSourceData(Iterator<String> sourceLinesIterator, List<LineReader> dataLineReaders, int numberOfLines) {
        this.lineReaders = dataLineReaders;
        this.linesIterator = sourceLinesIterator;
        this.numberOfLines = numberOfLines;
        this.currentLine = 0;
    }

    public Data compute() {
        Data data = new Data(this.numberOfLines);
        while (this.linesIterator.hasNext()) {
            ++this.currentLine;
            this.read(data, this.linesIterator.next(), this.linesIterator.hasNext());
        }
        return data;
    }

    private void read(Data data, String source, boolean hasNextLine) {
        data.linesHashesComputer.addLine(source);
        data.sourceHashComputer.addLine(source, hasNextLine);
        DbFileSources.Line.Builder lineBuilder = data.fileSourceBuilder.addLinesBuilder().setSource(source).setLine(this.currentLine);
        for (LineReader lineReader : this.lineReaders) {
            lineReader.read(lineBuilder);
        }
    }

    public static class Data {
        private static final Joiner LINE_RETURN_JOINER = Joiner.on((char)'\n');
        private final SourceLinesHashesComputer linesHashesComputer;
        private final SourceHashComputer sourceHashComputer = new SourceHashComputer();
        private final DbFileSources.Data.Builder fileSourceBuilder = DbFileSources.Data.newBuilder();

        public Data(int lineCount) {
            this.linesHashesComputer = new SourceLinesHashesComputer(lineCount);
        }

        public String getSrcHash() {
            return this.sourceHashComputer.getHash();
        }

        public String getLineHashes() {
            return LINE_RETURN_JOINER.join((Iterable)this.linesHashesComputer.getLineHashes());
        }

        public DbFileSources.Data getFileSourceData() {
            return this.fileSourceBuilder.build();
        }
    }
}

