/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.scm;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.server.computation.task.projectanalysis.scm.Changeset;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfo;

@Immutable
public class ScmInfoImpl
implements ScmInfo {
    @CheckForNull
    private final Changeset latestChangeset;
    private final Changeset[] lineChangesets;

    public ScmInfoImpl(Iterable<Changeset> lineChangesets) {
        Preconditions.checkState((!Iterables.isEmpty(lineChangesets) ? 1 : 0) != 0, (Object)"A ScmInfo must have at least one Changeset and does not support any null one");
        this.lineChangesets = (Changeset[])FluentIterable.from(lineChangesets).filter((Predicate)CheckNotNull.INSTANCE).toArray(Changeset.class);
        this.latestChangeset = ScmInfoImpl.computeLatestChangeset(lineChangesets);
    }

    private static Changeset computeLatestChangeset(Iterable<Changeset> lineChangesets) {
        Changeset latestChangeset = null;
        for (Changeset lineChangeset : lineChangesets) {
            if (latestChangeset != null && lineChangeset.getDate() <= latestChangeset.getDate()) continue;
            latestChangeset = lineChangeset;
        }
        return latestChangeset;
    }

    @Override
    public Changeset getLatestChangeset() {
        return this.latestChangeset;
    }

    @Override
    public Changeset getChangesetForLine(int lineNumber) {
        Preconditions.checkArgument((lineNumber > 0 && lineNumber <= this.lineChangesets.length ? 1 : 0) != 0, (String)"There's no changeset on line %s", (Object[])new Object[]{lineNumber});
        return this.lineChangesets[lineNumber - 1];
    }

    @Override
    public boolean hasChangesetForLine(int lineNumber) {
        return lineNumber <= this.lineChangesets.length;
    }

    @Override
    public Iterable<Changeset> getAllChangesets() {
        return Arrays.asList(this.lineChangesets);
    }

    public String toString() {
        return "ScmInfoImpl{latestChangeset=" + this.latestChangeset + ", lineChangesets=" + Arrays.toString(this.lineChangesets) + '}';
    }

    private static enum CheckNotNull implements Predicate<Changeset>
    {
        INSTANCE;


        public boolean apply(@Nullable Changeset input) {
            Preconditions.checkState((input != null ? 1 : 0) != 0, (Object)"Null changeset are not allowed");
            return true;
        }
    }
}

