/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.qualitymodel;

import com.google.common.base.Optional;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareVisitor;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.formula.counter.LongValue;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.projectanalysis.period.Period;
import org.sonar.server.computation.task.projectanalysis.period.PeriodHolder;
import org.sonar.server.computation.task.projectanalysis.qualitymodel.RatingGrid;
import org.sonar.server.computation.task.projectanalysis.qualitymodel.RatingSettings;
import org.sonar.server.computation.task.projectanalysis.scm.Changeset;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfo;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfoRepository;

public class NewMaintainabilityMeasuresVisitor
extends PathAwareVisitorAdapter<Counter> {
    private static final Logger LOG = Loggers.get(NewMaintainabilityMeasuresVisitor.class);
    private final ScmInfoRepository scmInfoRepository;
    private final MeasureRepository measureRepository;
    private final PeriodHolder periodHolder;
    private final RatingSettings ratingSettings;
    private final RatingGrid ratingGrid;
    private final Metric newDebtMetric;
    private final Metric nclocDataMetric;
    private final Metric newDebtRatioMetric;
    private final Metric newMaintainabilityRatingMetric;

    public NewMaintainabilityMeasuresVisitor(MetricRepository metricRepository, MeasureRepository measureRepository, ScmInfoRepository scmInfoRepository, PeriodHolder periodHolder, RatingSettings ratingSettings) {
        super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.POST_ORDER, CounterFactory.INSTANCE);
        this.measureRepository = measureRepository;
        this.scmInfoRepository = scmInfoRepository;
        this.periodHolder = periodHolder;
        this.ratingSettings = ratingSettings;
        this.ratingGrid = ratingSettings.getRatingGrid();
        this.newDebtMetric = metricRepository.getByKey("new_technical_debt");
        this.nclocDataMetric = metricRepository.getByKey("ncloc_data");
        this.newDebtRatioMetric = metricRepository.getByKey("new_sqale_debt_ratio");
        this.newMaintainabilityRatingMetric = metricRepository.getByKey("new_maintainability_rating");
    }

    @Override
    public void visitProject(Component project, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveNewDebtRatioMeasure(project, path);
    }

    @Override
    public void visitModule(Component module, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveNewDebtRatioMeasure(module, path);
        NewMaintainabilityMeasuresVisitor.increaseNewDebtAndDevCostOfParent(path);
    }

    @Override
    public void visitDirectory(Component directory, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveNewDebtRatioMeasure(directory, path);
        NewMaintainabilityMeasuresVisitor.increaseNewDebtAndDevCostOfParent(path);
    }

    @Override
    public void visitFile(Component file, PathAwareVisitor.Path<Counter> path) {
        this.initNewDebtRatioCounter(file, path);
        this.computeAndSaveNewDebtRatioMeasure(file, path);
        NewMaintainabilityMeasuresVisitor.increaseNewDebtAndDevCostOfParent(path);
    }

    private void computeAndSaveNewDebtRatioMeasure(Component component, PathAwareVisitor.Path<Counter> path) {
        if (!this.periodHolder.hasPeriod()) {
            return;
        }
        double density = NewMaintainabilityMeasuresVisitor.computeDensity(path.current());
        double newDebtRatio = 100.0 * density;
        double newMaintainability = this.ratingGrid.getRatingForDensity(density).getIndex();
        this.measureRepository.add(component, this.newDebtRatioMetric, Measure.newMeasureBuilder().setVariation(newDebtRatio).createNoValue());
        this.measureRepository.add(component, this.newMaintainabilityRatingMetric, Measure.newMeasureBuilder().setVariation(newMaintainability).createNoValue());
    }

    private static double computeDensity(Counter counter) {
        long developmentCost;
        LongValue newDebt = counter.getNewDebt();
        if (newDebt.isSet() && (developmentCost = counter.getDevCost().getValue()) != 0L) {
            return (double)newDebt.getValue() / (double)developmentCost;
        }
        return 0.0;
    }

    private static long getLongValue(Optional<Measure> measure) {
        if (!measure.isPresent()) {
            return 0L;
        }
        return NewMaintainabilityMeasuresVisitor.getLongValue((Measure)measure.get());
    }

    private static long getLongValue(Measure measure) {
        if (measure.hasVariation()) {
            return (long)measure.getVariation();
        }
        return 0L;
    }

    private void initNewDebtRatioCounter(Component file, PathAwareVisitor.Path<Counter> path) {
        if (!this.periodHolder.hasPeriod()) {
            return;
        }
        Optional<Measure> nclocDataMeasure = this.measureRepository.getRawMeasure(file, this.nclocDataMetric);
        if (!nclocDataMeasure.isPresent()) {
            return;
        }
        Optional<ScmInfo> scmInfoOptional = this.scmInfoRepository.getScmInfo(file);
        if (!scmInfoOptional.isPresent()) {
            LOG.trace(String.format("No changeset for file %s. Dev cost will be zero.", file.getKey()));
            return;
        }
        ScmInfo scmInfo = (ScmInfo)scmInfoOptional.get();
        this.initNewDebtRatioCounter(path.current(), file, (Measure)nclocDataMeasure.get(), scmInfo);
    }

    private void initNewDebtRatioCounter(Counter devCostCounter, Component file, Measure nclocDataMeasure, ScmInfo scmInfo) {
        boolean hasDevCost = false;
        long lineDevCost = this.ratingSettings.getDevCost(file.getFileAttributes().getLanguageKey());
        for (Integer nclocLineIndex : NewMaintainabilityMeasuresVisitor.nclocLineIndexes(nclocDataMeasure)) {
            Changeset changeset = scmInfo.getChangesetForLine(nclocLineIndex);
            Period period = this.periodHolder.getPeriod();
            if (!NewMaintainabilityMeasuresVisitor.isLineInPeriod(changeset.getDate(), period)) continue;
            devCostCounter.incrementDevCost(lineDevCost);
            hasDevCost = true;
        }
        if (hasDevCost) {
            long newDebt = NewMaintainabilityMeasuresVisitor.getLongValue(this.measureRepository.getRawMeasure(file, this.newDebtMetric));
            devCostCounter.incrementNewDebt(newDebt);
        }
    }

    private static void increaseNewDebtAndDevCostOfParent(PathAwareVisitor.Path<Counter> path) {
        path.parent().add(path.current());
    }

    private static boolean isLineInPeriod(long lineDate, Period period) {
        return lineDate > period.getSnapshotDate();
    }

    private static Iterable<Integer> nclocLineIndexes(Measure nclocDataMeasure) {
        Map parsedNclocData = KeyValueFormat.parse((String)nclocDataMeasure.getData(), (KeyValueFormat.Converter)KeyValueFormat.newIntegerConverter(), (KeyValueFormat.Converter)KeyValueFormat.newIntegerConverter());
        return parsedNclocData.entrySet().stream().filter(entry -> (Integer)entry.getValue() == 1).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private static class CounterFactory
    extends PathAwareVisitorAdapter.SimpleStackElementFactory<Counter> {
        public static final CounterFactory INSTANCE = new CounterFactory();

        private CounterFactory() {
        }

        @Override
        public Counter createForAny(Component component) {
            return new Counter();
        }
    }

    public static final class Counter {
        private final LongValue newDebt = new LongValue();
        private final LongValue devCost = new LongValue();

        public void add(Counter counter) {
            this.newDebt.increment(counter.newDebt);
            this.devCost.increment(counter.devCost);
        }

        LongValue incrementNewDebt(long value) {
            return this.newDebt.increment(value);
        }

        LongValue incrementDevCost(long value) {
            return this.devCost.increment(value);
        }

        LongValue getNewDebt() {
            return this.newDebt;
        }

        LongValue getDevCost() {
            return this.devCost;
        }
    }
}

