/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.qualitygate;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.qualitygate.Condition;
import org.sonar.server.computation.task.projectanalysis.qualitygate.EvaluationResult;

public final class ConditionEvaluator {
    public EvaluationResult evaluate(Condition condition, Measure measure) {
        Preconditions.checkArgument((condition.getMetric().getType() != Metric.MetricType.DATA ? 1 : 0) != 0, (Object)"Conditions on MetricType DATA are not supported");
        Comparable measureComparable = ConditionEvaluator.parseMeasure(condition, measure);
        if (measureComparable == null) {
            return new EvaluationResult(Measure.Level.OK, null);
        }
        return ConditionEvaluator.evaluateCondition(condition, measureComparable, Measure.Level.ERROR).orElseGet(() -> ConditionEvaluator.evaluateCondition(condition, measureComparable, Measure.Level.WARN).orElseGet(() -> new EvaluationResult(Measure.Level.OK, measureComparable)));
    }

    private static Optional<EvaluationResult> evaluateCondition(Condition condition, Comparable<?> measureComparable, Measure.Level alertLevel) {
        String conditionValue = ConditionEvaluator.getValueToEval(condition, alertLevel);
        if (StringUtils.isEmpty((String)conditionValue)) {
            return Optional.empty();
        }
        try {
            Comparable conditionComparable = ConditionEvaluator.parseConditionValue(condition.getMetric(), conditionValue);
            if (ConditionEvaluator.doesReachThresholds(measureComparable, conditionComparable, condition)) {
                return Optional.of(new EvaluationResult(alertLevel, measureComparable));
            }
            return Optional.empty();
        }
        catch (NumberFormatException badValueFormat) {
            throw new IllegalArgumentException(String.format("Quality Gate: Unable to parse value '%s' to compare against %s", conditionValue, condition.getMetric().getName()));
        }
    }

    private static String getValueToEval(Condition condition, Measure.Level alertLevel) {
        if (Measure.Level.ERROR.equals((Object)alertLevel)) {
            return condition.getErrorThreshold();
        }
        if (Measure.Level.WARN.equals((Object)alertLevel)) {
            return condition.getWarningThreshold();
        }
        throw new IllegalStateException(alertLevel.toString());
    }

    private static boolean doesReachThresholds(Comparable measureValue, Comparable criteriaValue, Condition condition) {
        int comparison = measureValue.compareTo(criteriaValue);
        switch (condition.getOperator()) {
            case EQUALS: {
                return comparison == 0;
            }
            case NOT_EQUALS: {
                return comparison != 0;
            }
            case GREATER_THAN: {
                return comparison > 0;
            }
            case LESS_THAN: {
                return comparison < 0;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported operator '%s'", new Object[]{condition.getOperator()}));
    }

    private static Comparable parseConditionValue(Metric metric, String value) {
        switch (metric.getType().getValueType()) {
            case BOOLEAN: {
                return Boolean.valueOf(Integer.parseInt(value) == 1);
            }
            case INT: {
                return ConditionEvaluator.parseInteger(value);
            }
            case LONG: {
                return Long.valueOf(Long.parseLong(value));
            }
            case DOUBLE: {
                return Double.valueOf(Double.parseDouble(value));
            }
            case STRING: 
            case LEVEL: {
                return value;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported value type %s. Can not convert condition value", new Object[]{metric.getType().getValueType()}));
    }

    private static Comparable<Integer> parseInteger(String value) {
        return value.contains(".") ? Integer.parseInt(value.substring(0, value.indexOf(46))) : Integer.parseInt(value);
    }

    @CheckForNull
    private static Comparable parseMeasure(Condition condition, Measure measure) {
        if (condition.hasPeriod()) {
            return ConditionEvaluator.parseMeasureFromVariation(condition, measure);
        }
        switch (measure.getValueType()) {
            case BOOLEAN: {
                return Boolean.valueOf(measure.getBooleanValue());
            }
            case INT: {
                return Integer.valueOf(measure.getIntValue());
            }
            case LONG: {
                return Long.valueOf(measure.getLongValue());
            }
            case DOUBLE: {
                return Double.valueOf(measure.getDoubleValue());
            }
            case STRING: {
                return measure.getStringValue();
            }
            case LEVEL: {
                return measure.getLevelValue().name();
            }
            case NO_VALUE: {
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported measure ValueType %s. Can not parse measure to a Comparable", new Object[]{measure.getValueType()}));
    }

    @CheckForNull
    private static Comparable parseMeasureFromVariation(Condition condition, Measure measure) {
        Optional<Double> periodValue = ConditionEvaluator.getPeriodValue(measure);
        if (periodValue.isPresent()) {
            switch (condition.getMetric().getType().getValueType()) {
                case BOOLEAN: {
                    return Boolean.valueOf(periodValue.get().intValue() == 1);
                }
                case INT: {
                    return Integer.valueOf(periodValue.get().intValue());
                }
                case LONG: {
                    return Long.valueOf(periodValue.get().longValue());
                }
                case DOUBLE: {
                    return periodValue.get();
                }
            }
            throw new IllegalArgumentException("Period conditions are not supported for metric type " + (Object)((Object)condition.getMetric().getType()));
        }
        return null;
    }

    private static Optional<Double> getPeriodValue(Measure measure) {
        return measure.hasVariation() ? Optional.of(measure.getVariation()) : Optional.empty();
    }
}

