/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.metric;

import javax.annotation.CheckForNull;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;

public interface Metric {
    public int getId();

    public String getKey();

    public String getName();

    public MetricType getType();

    public boolean isBestValueOptimized();

    @CheckForNull
    public Double getBestValue();

    public int getDecimalScale();

    public static enum MetricType {
        INT(Measure.ValueType.INT),
        MILLISEC(Measure.ValueType.LONG),
        RATING(Measure.ValueType.INT),
        WORK_DUR(Measure.ValueType.LONG),
        FLOAT(Measure.ValueType.DOUBLE),
        PERCENT(Measure.ValueType.DOUBLE),
        BOOL(Measure.ValueType.BOOLEAN),
        STRING(Measure.ValueType.STRING),
        DISTRIB(Measure.ValueType.STRING),
        DATA(Measure.ValueType.STRING),
        LEVEL(Measure.ValueType.LEVEL);

        private final Measure.ValueType valueType;

        private MetricType(Measure.ValueType valueType) {
            this.valueType = valueType;
        }

        public Measure.ValueType getValueType() {
            return this.valueType;
        }
    }
}

