/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue.commonrule;

import com.google.common.base.Optional;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.issue.commonrule.CommonRule;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.projectanalysis.qualityprofile.ActiveRule;
import org.sonar.server.computation.task.projectanalysis.qualityprofile.ActiveRulesHolder;

public class SkippedTestRule
extends CommonRule {
    private final MeasureRepository measureRepository;
    private final Metric skippedTestsMetric;

    public SkippedTestRule(ActiveRulesHolder activeRulesHolder, MeasureRepository measureRepository, MetricRepository metricRepository) {
        super(activeRulesHolder, "SkippedUnitTests");
        this.measureRepository = measureRepository;
        this.skippedTestsMetric = metricRepository.getByKey("skipped_tests");
    }

    @Override
    protected CommonRule.CommonRuleIssue doProcessFile(Component file, ActiveRule activeRule) {
        int skipped;
        Optional<Measure> measure = this.measureRepository.getRawMeasure(file, this.skippedTestsMetric);
        int n = skipped = measure.isPresent() ? ((Measure)measure.get()).getIntValue() : 0;
        if (skipped > 0) {
            String message = String.format("Fix or remove skipped unit tests in file \"%s\".", file.getName());
            return new CommonRule.CommonRuleIssue(skipped, message);
        }
        return null;
    }
}

