/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.tracking.Input;
import org.sonar.core.issue.tracking.LazyInput;
import org.sonar.core.issue.tracking.LineHashSequence;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.filemove.MovedFilesRepository;
import org.sonar.server.computation.task.projectanalysis.issue.ComponentIssuesLoader;

public class TrackerBaseInputFactory {
    private static final LineHashSequence EMPTY_LINE_HASH_SEQUENCE = new LineHashSequence(Collections.emptyList());
    private final ComponentIssuesLoader issuesLoader;
    private final DbClient dbClient;
    private final MovedFilesRepository movedFilesRepository;

    public TrackerBaseInputFactory(ComponentIssuesLoader issuesLoader, DbClient dbClient, MovedFilesRepository movedFilesRepository) {
        this.issuesLoader = issuesLoader;
        this.dbClient = dbClient;
        this.movedFilesRepository = movedFilesRepository;
    }

    public Input<DefaultIssue> create(Component component) {
        return new BaseLazyInput(component, (MovedFilesRepository.OriginalFile)this.movedFilesRepository.getOriginalFile(component).orNull());
    }

    private class BaseLazyInput
    extends LazyInput<DefaultIssue> {
        private final Component component;
        @CheckForNull
        private final String effectiveUuid;

        private BaseLazyInput(@Nullable Component component, MovedFilesRepository.OriginalFile originalFile) {
            this.component = component;
            this.effectiveUuid = originalFile == null ? component.getUuid() : originalFile.getUuid();
        }

        protected LineHashSequence loadLineHashSequence() {
            if (this.component.getType() != Component.Type.FILE) {
                return EMPTY_LINE_HASH_SEQUENCE;
            }
            try (DbSession session = TrackerBaseInputFactory.this.dbClient.openSession(false);){
                List hashes = TrackerBaseInputFactory.this.dbClient.fileSourceDao().selectLineHashes(session, this.effectiveUuid);
                if (hashes == null || hashes.isEmpty()) {
                    LineHashSequence lineHashSequence = EMPTY_LINE_HASH_SEQUENCE;
                    return lineHashSequence;
                }
                LineHashSequence lineHashSequence = new LineHashSequence(hashes);
                return lineHashSequence;
            }
        }

        protected List<DefaultIssue> loadIssues() {
            return TrackerBaseInputFactory.this.issuesLoader.loadForComponentUuid(this.effectiveUuid);
        }
    }
}

