/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import com.google.common.base.Strings;
import javax.annotation.CheckForNull;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.component.ConfigurationRepository;

public class DefaultAssignee {
    private static final Logger LOG = Loggers.get(DefaultAssignee.class);
    private final DbClient dbClient;
    private final ConfigurationRepository configRepository;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private boolean loaded = false;
    private String login = null;

    public DefaultAssignee(DbClient dbClient, ConfigurationRepository configRepository, AnalysisMetadataHolder analysisMetadataHolder) {
        this.dbClient = dbClient;
        this.configRepository = configRepository;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @CheckForNull
    public String loadDefaultAssigneeLogin() {
        if (this.loaded) {
            return this.login;
        }
        String configuredLogin = this.configRepository.getConfiguration().get("sonar.issues.defaultAssigneeLogin").orElse(null);
        if (!Strings.isNullOrEmpty((String)configuredLogin) && this.isValidLogin(configuredLogin)) {
            this.login = configuredLogin;
        }
        this.loaded = true;
        return this.login;
    }

    private boolean isValidLogin(String login) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto user = this.dbClient.userDao().selectActiveUserByLogin(dbSession, login);
            if (user == null) {
                LOG.info("Property {} is set with an unknown login: {}", (Object)"sonar.issues.defaultAssigneeLogin", (Object)login);
                boolean bl = false;
                return bl;
            }
            if (!this.isUserMemberOfOrganization(dbSession, user)) {
                LOG.info("Property {} is set with a user which is not member of the organization of the project : {}", (Object)"sonar.issues.defaultAssigneeLogin", (Object)login);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    private boolean isUserMemberOfOrganization(DbSession dbSession, UserDto user) {
        return this.dbClient.organizationMemberDao().select(dbSession, this.analysisMetadataHolder.getOrganization().getUuid(), user.getId().intValue()).isPresent();
    }
}

