/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.event;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Event {
    private final String name;
    private final Category category;
    @Nullable
    private final String data;
    @Nullable
    private final String description;

    private Event(String name, Category category, @Nullable String data, @Nullable String description) {
        this.name = Objects.requireNonNull(name);
        this.category = Objects.requireNonNull(category);
        this.data = data;
        this.description = description;
    }

    public static Event createAlert(String name, @Nullable String data, @Nullable String description) {
        return new Event(name, Category.ALERT, data, description);
    }

    public static Event createProfile(String name, @Nullable String data, @Nullable String description) {
        return new Event(name, Category.PROFILE, data, description);
    }

    public String getName() {
        return this.name;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getData() {
        return this.data;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equals(this.name, event.name) && Objects.equals((Object)this.category, (Object)event.category);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.category});
    }

    public static enum Category {
        ALERT,
        PROFILE;

    }
}

