/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.duplication;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.duplication.AbstractDuplicate;
import org.sonar.server.computation.task.projectanalysis.duplication.TextBlock;

@Immutable
public class InProjectDuplicate
extends AbstractDuplicate {
    private final Component file;

    public InProjectDuplicate(Component file, TextBlock textBlock) {
        super(textBlock);
        Objects.requireNonNull(file, "file can not be null");
        Preconditions.checkArgument((file.getType() == Component.Type.FILE ? 1 : 0) != 0, (Object)"file must be of type FILE");
        this.file = file;
    }

    public Component getFile() {
        return this.file;
    }

    public String toString() {
        return "InProjectDuplicate{file=" + this.file + ", textBlock=" + this.getTextBlock() + '}';
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InProjectDuplicate that = (InProjectDuplicate)o;
        return this.file.equals(that.file);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.file);
    }
}

