/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.api.posttask;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.ce.posttask.Analysis;
import org.sonar.api.ce.posttask.Branch;
import org.sonar.api.ce.posttask.CeTask;
import org.sonar.api.ce.posttask.PostProjectAnalysisTask;
import org.sonar.api.ce.posttask.Project;
import org.sonar.api.ce.posttask.QualityGate;
import org.sonar.api.ce.posttask.ScannerContext;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.queue.CeTask;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.analysis.Branch;
import org.sonar.server.computation.task.projectanalysis.api.posttask.BranchImpl;
import org.sonar.server.computation.task.projectanalysis.api.posttask.CeTaskImpl;
import org.sonar.server.computation.task.projectanalysis.api.posttask.ConditionToCondition;
import org.sonar.server.computation.task.projectanalysis.api.posttask.ProjectImpl;
import org.sonar.server.computation.task.projectanalysis.api.posttask.QualityGateImpl;
import org.sonar.server.computation.task.projectanalysis.api.posttask.ScannerContextImpl;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;
import org.sonar.server.computation.task.projectanalysis.qualitygate.Condition;
import org.sonar.server.computation.task.projectanalysis.qualitygate.ConditionStatus;
import org.sonar.server.computation.task.projectanalysis.qualitygate.QualityGate;
import org.sonar.server.computation.task.projectanalysis.qualitygate.QualityGateHolder;
import org.sonar.server.computation.task.projectanalysis.qualitygate.QualityGateStatus;
import org.sonar.server.computation.task.projectanalysis.qualitygate.QualityGateStatusHolder;
import org.sonar.server.computation.task.step.ComputationStepExecutor;

public class PostProjectAnalysisTasksExecutor
implements ComputationStepExecutor.Listener {
    private static final PostProjectAnalysisTask[] NO_POST_PROJECT_ANALYSIS_TASKS = new PostProjectAnalysisTask[0];
    private static final Logger LOG = Loggers.get(PostProjectAnalysisTasksExecutor.class);
    private final CeTask ceTask;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final QualityGateHolder qualityGateHolder;
    private final QualityGateStatusHolder qualityGateStatusHolder;
    private final PostProjectAnalysisTask[] postProjectAnalysisTasks;
    private final BatchReportReader reportReader;
    private final System2 system2;

    public PostProjectAnalysisTasksExecutor(CeTask ceTask, AnalysisMetadataHolder analysisMetadataHolder, QualityGateHolder qualityGateHolder, QualityGateStatusHolder qualityGateStatusHolder, BatchReportReader reportReader, System2 system2) {
        this(ceTask, analysisMetadataHolder, qualityGateHolder, qualityGateStatusHolder, reportReader, system2, null);
    }

    public PostProjectAnalysisTasksExecutor(CeTask ceTask, AnalysisMetadataHolder analysisMetadataHolder, QualityGateHolder qualityGateHolder, QualityGateStatusHolder qualityGateStatusHolder, BatchReportReader reportReader, System2 system2, @Nullable PostProjectAnalysisTask[] postProjectAnalysisTasks) {
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.qualityGateHolder = qualityGateHolder;
        this.qualityGateStatusHolder = qualityGateStatusHolder;
        this.ceTask = ceTask;
        this.reportReader = reportReader;
        this.postProjectAnalysisTasks = postProjectAnalysisTasks == null ? NO_POST_PROJECT_ANALYSIS_TASKS : postProjectAnalysisTasks;
        this.system2 = system2;
    }

    @Override
    public void finished(boolean allStepsExecuted) {
        if (this.postProjectAnalysisTasks.length == 0) {
            return;
        }
        ProjectAnalysisImpl projectAnalysis = this.createProjectAnalysis(allStepsExecuted ? CeTask.Status.SUCCESS : CeTask.Status.FAILED);
        for (PostProjectAnalysisTask postProjectAnalysisTask : this.postProjectAnalysisTasks) {
            PostProjectAnalysisTasksExecutor.executeTask(projectAnalysis, postProjectAnalysisTask);
        }
    }

    private static void executeTask(ProjectAnalysisImpl projectAnalysis, PostProjectAnalysisTask postProjectAnalysisTask) {
        try {
            postProjectAnalysisTask.finished((PostProjectAnalysisTask.ProjectAnalysis)projectAnalysis);
        }
        catch (Exception e) {
            LOG.error("Execution of task " + postProjectAnalysisTask.getClass() + " failed", (Throwable)e);
        }
    }

    private ProjectAnalysisImpl createProjectAnalysis(CeTask.Status status) {
        return new ProjectAnalysisImpl(new CeTaskImpl(this.ceTask.getUuid(), status), PostProjectAnalysisTasksExecutor.createProject(this.ceTask), this.getAnalysis().orElse(null), this.getAnalysis().map(a -> a.getDate().getTime()).orElse(this.system2.now()), ScannerContextImpl.from(this.reportReader.readContextProperties()), status == CeTask.Status.SUCCESS ? this.createQualityGate() : null, this.createBranch());
    }

    private Optional<Analysis> getAnalysis() {
        Long analysisDate = this.getAnalysisDate();
        if (analysisDate != null) {
            return Optional.of(new AnalysisImpl(this.analysisMetadataHolder.getUuid(), analysisDate));
        }
        return Optional.empty();
    }

    private static Project createProject(CeTask ceTask) {
        return new ProjectImpl(ceTask.getComponentUuid(), ceTask.getComponentKey(), ceTask.getComponentName());
    }

    @CheckForNull
    private Long getAnalysisDate() {
        if (this.analysisMetadataHolder.hasAnalysisDateBeenSet()) {
            return this.analysisMetadataHolder.getAnalysisDate();
        }
        return null;
    }

    @CheckForNull
    private QualityGateImpl createQualityGate() {
        com.google.common.base.Optional<QualityGate> qualityGateOptional = this.qualityGateHolder.getQualityGate();
        if (qualityGateOptional.isPresent()) {
            QualityGate qualityGate = (QualityGate)qualityGateOptional.get();
            return new QualityGateImpl(String.valueOf(qualityGate.getId()), qualityGate.getName(), PostProjectAnalysisTasksExecutor.convert(this.qualityGateStatusHolder.getStatus()), PostProjectAnalysisTasksExecutor.convert(qualityGate.getConditions(), this.qualityGateStatusHolder.getStatusPerConditions()));
        }
        return null;
    }

    @CheckForNull
    private BranchImpl createBranch() {
        Branch analysisBranch = this.analysisMetadataHolder.getBranch();
        if (!analysisBranch.isLegacyFeature()) {
            return new BranchImpl(analysisBranch.isMain(), analysisBranch.getName(), Branch.Type.valueOf((String)analysisBranch.getType().name()));
        }
        return null;
    }

    private static QualityGate.Status convert(QualityGateStatus status) {
        switch (status) {
            case OK: {
                return QualityGate.Status.OK;
            }
            case WARN: {
                return QualityGate.Status.WARN;
            }
            case ERROR: {
                return QualityGate.Status.ERROR;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported value '%s' of QualityGateStatus can not be converted to QualityGate.Status", new Object[]{status}));
    }

    private static Collection<QualityGate.Condition> convert(Set<Condition> conditions, Map<Condition, ConditionStatus> statusPerConditions) {
        return conditions.stream().map(new ConditionToCondition(statusPerConditions)::apply).collect(Collectors.toList());
    }

    private static class AnalysisImpl
    implements Analysis {
        private final String analysisUuid;
        private final long date;

        private AnalysisImpl(String analysisUuid, long date) {
            this.analysisUuid = analysisUuid;
            this.date = date;
        }

        public String getAnalysisUuid() {
            return this.analysisUuid;
        }

        public Date getDate() {
            return new Date(this.date);
        }
    }

    private static class ProjectAnalysisImpl
    implements PostProjectAnalysisTask.ProjectAnalysis {
        private final org.sonar.api.ce.posttask.CeTask ceTask;
        private final Project project;
        private final long date;
        private final ScannerContext scannerContext;
        @Nullable
        private final org.sonar.api.ce.posttask.QualityGate qualityGate;
        @Nullable
        private final org.sonar.api.ce.posttask.Branch branch;
        @Nullable
        private final Analysis analysis;

        private ProjectAnalysisImpl(org.sonar.api.ce.posttask.CeTask ceTask, Project project, @Nullable Analysis analysis, long date, ScannerContext scannerContext, @Nullable org.sonar.api.ce.posttask.QualityGate qualityGate, @Nullable org.sonar.api.ce.posttask.Branch branch) {
            this.ceTask = Objects.requireNonNull(ceTask, "ceTask can not be null");
            this.project = Objects.requireNonNull(project, "project can not be null");
            this.analysis = analysis;
            this.date = date;
            this.scannerContext = Objects.requireNonNull(scannerContext, "scannerContext can not be null");
            this.qualityGate = qualityGate;
            this.branch = branch;
        }

        public org.sonar.api.ce.posttask.CeTask getCeTask() {
            return this.ceTask;
        }

        public Project getProject() {
            return this.project;
        }

        public Optional<org.sonar.api.ce.posttask.Branch> getBranch() {
            return Optional.ofNullable(this.branch);
        }

        @CheckForNull
        public org.sonar.api.ce.posttask.QualityGate getQualityGate() {
            return this.qualityGate;
        }

        public Date getDate() {
            return new Date(this.date);
        }

        public Optional<Date> getAnalysisDate() {
            return this.analysis == null ? Optional.empty() : Optional.ofNullable(this.analysis.getDate());
        }

        public Optional<Analysis> getAnalysis() {
            return Optional.ofNullable(this.analysis);
        }

        public ScannerContext getScannerContext() {
            return this.scannerContext;
        }

        public String toString() {
            return "ProjectAnalysis{ceTask=" + this.ceTask + ", project=" + this.project + ", date=" + this.date + ", scannerContext=" + this.scannerContext + ", qualityGate=" + this.qualityGate + ", analysis=" + this.analysis + '}';
        }
    }
}

