/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.analysis;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Analysis {
    private long id;
    private String uuid;
    private long createdAt;

    private Analysis(Builder builder) {
        this.id = builder.id;
        this.uuid = builder.uuid;
        this.createdAt = builder.createdAt;
    }

    public long getId() {
        return this.id;
    }

    public String getUuid() {
        return this.uuid;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Analysis analysis = (Analysis)o;
        return this.id == analysis.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        return "Analysis{id=" + this.id + ", uuid='" + this.uuid + '\'' + ", createdAt=" + this.createdAt + '}';
    }

    public static final class Builder {
        @CheckForNull
        private Long id;
        @CheckForNull
        private String uuid;
        @CheckForNull
        private Long createdAt;

        public Builder setId(long id) {
            this.id = id;
            return this;
        }

        public Builder setUuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder setCreatedAt(long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Analysis build() {
            Preconditions.checkNotNull((Object)this.id, (Object)"id cannot be null");
            Preconditions.checkNotNull((Object)this.uuid, (Object)"uuid cannot be null");
            Preconditions.checkNotNull((Object)this.createdAt, (Object)"createdAt cannot be null");
            return new Analysis(this);
        }
    }
}

