/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.dbcleaner;

import java.util.Collection;
import java.util.List;
import org.sonar.api.server.ServerSide;
import org.sonar.db.purge.PurgeListener;
import org.sonar.server.component.index.ComponentIndexer;
import org.sonar.server.issue.index.IssueIndexer;
import org.sonar.server.test.index.TestIndexer;

@ServerSide
public class IndexPurgeListener
implements PurgeListener {
    private final TestIndexer testIndexer;
    private final IssueIndexer issueIndexer;
    private final ComponentIndexer componentIndexer;

    public IndexPurgeListener(TestIndexer testIndexer, IssueIndexer issueIndexer, ComponentIndexer componentIndexer) {
        this.testIndexer = testIndexer;
        this.issueIndexer = issueIndexer;
        this.componentIndexer = componentIndexer;
    }

    public void onComponentsDisabling(String projectUuid, Collection<String> disabledComponentUuids) {
        this.componentIndexer.delete(projectUuid, disabledComponentUuids);
        disabledComponentUuids.forEach(this::onComponentDisabling);
    }

    private void onComponentDisabling(String uuid) {
        this.testIndexer.deleteByFile(uuid);
    }

    public void onIssuesRemoval(String projectUuid, List<String> issueKeys) {
        this.issueIndexer.deleteByKeys(projectUuid, issueKeys);
    }
}

