/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.index;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class SuggestionQuery {
    public static final int DEFAULT_LIMIT = 6;
    private final String query;
    private final Collection<String> qualifiers;
    private final Set<String> recentlyBrowsedKeys;
    private final Set<String> favoriteKeys;
    private final int skip;
    private final int limit;

    private SuggestionQuery(Builder builder) {
        this.query = Objects.requireNonNull(builder.query);
        this.qualifiers = Objects.requireNonNull(builder.qualifiers);
        this.recentlyBrowsedKeys = Objects.requireNonNull(builder.recentlyBrowsedKeys);
        this.favoriteKeys = Objects.requireNonNull(builder.favoriteKeys);
        this.skip = builder.skip;
        this.limit = builder.limit;
    }

    public Collection<String> getQualifiers() {
        return this.qualifiers;
    }

    public String getQuery() {
        return this.query;
    }

    public Set<String> getRecentlyBrowsedKeys() {
        return this.recentlyBrowsedKeys;
    }

    public int getSkip() {
        return this.skip;
    }

    public int getLimit() {
        return this.limit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<String> getFavoriteKeys() {
        return this.favoriteKeys;
    }

    public static class Builder {
        private String query;
        private Collection<String> qualifiers = Collections.emptyList();
        private Set<String> recentlyBrowsedKeys = Collections.emptySet();
        private Set<String> favoriteKeys = Collections.emptySet();
        private int skip = 0;
        private int limit = 6;

        private Builder() {
        }

        public Builder setQuery(String query) {
            Preconditions.checkArgument((query.length() >= 2 ? 1 : 0) != 0, (String)"Query must be at least two characters long: %s", (Object[])new Object[]{query});
            this.query = query;
            return this;
        }

        public Builder setQualifiers(Collection<String> qualifiers) {
            this.qualifiers = Collections.unmodifiableCollection(qualifiers);
            return this;
        }

        public Builder setRecentlyBrowsedKeys(Set<String> recentlyBrowsedKeys) {
            this.recentlyBrowsedKeys = Collections.unmodifiableSet(recentlyBrowsedKeys);
            return this;
        }

        public Builder setFavoriteKeys(Set<String> favoriteKeys) {
            this.favoriteKeys = Collections.unmodifiableSet(favoriteKeys);
            return this;
        }

        public Builder setSkip(int skip) {
            Preconditions.checkArgument((this.limit > 0 ? 1 : 0) != 0, (String)"Skip has to be strictly positive: %s", (Object[])new Object[]{this.limit});
            this.skip = skip;
            return this;
        }

        public Builder setLimit(int limit) {
            Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (String)"Limit has to be strictly positive: %s", (Object[])new Object[]{limit});
            this.limit = limit;
            return this;
        }

        public SuggestionQuery build() {
            return new SuggestionQuery(this);
        }
    }
}

