/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.index;

import org.sonar.api.config.Configuration;
import org.sonar.server.es.DefaultIndexSettingsElement;
import org.sonar.server.es.IndexDefinition;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.NewIndex;

public class ComponentIndexDefinition
implements IndexDefinition {
    public static final IndexType INDEX_TYPE_COMPONENT = new IndexType("components", "component");
    public static final String FIELD_UUID = "uuid";
    public static final String FIELD_PROJECT_UUID = "project_uuid";
    public static final String FIELD_ORGANIZATION_UUID = "organization_uuid";
    public static final String FIELD_KEY = "key";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_QUALIFIER = "qualifier";
    public static final String FIELD_LANGUAGE = "language";
    private static final int DEFAULT_NUMBER_OF_SHARDS = 5;
    static final DefaultIndexSettingsElement[] NAME_ANALYZERS = new DefaultIndexSettingsElement[]{DefaultIndexSettingsElement.SORTABLE_ANALYZER, DefaultIndexSettingsElement.SEARCH_PREFIX_ANALYZER, DefaultIndexSettingsElement.SEARCH_PREFIX_CASE_INSENSITIVE_ANALYZER, DefaultIndexSettingsElement.SEARCH_GRAMS_ANALYZER};
    private final Configuration config;

    public ComponentIndexDefinition(Configuration config) {
        this.config = config;
    }

    @Override
    public void define(IndexDefinition.IndexDefinitionContext context) {
        NewIndex index = context.create(INDEX_TYPE_COMPONENT.getIndex(), NewIndex.SettingsConfiguration.newBuilder(this.config).setRefreshInterval(-1).setDefaultNbOfShards(5).build());
        NewIndex.NewIndexType mapping = index.createType(INDEX_TYPE_COMPONENT.getType()).requireProjectAuthorization();
        ((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_UUID).disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_PROJECT_UUID).disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_KEY).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        ((NewIndex.StringFieldBuilder)((NewIndex.StringFieldBuilder)mapping.textFieldBuilder(FIELD_NAME).withFieldData().termVectorWithPositionOffsets()).addSubFields(NAME_ANALYZERS)).build();
        mapping.keywordFieldBuilder(FIELD_QUALIFIER).build();
        ((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_LANGUAGE).disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ORGANIZATION_UUID).disableNorms()).build();
    }
}

