/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.component.ComponentValidator;

@Immutable
public class NewComponent {
    private final String organizationUuid;
    private final String key;
    private final String branch;
    private final String qualifier;
    private final String name;
    private final boolean isPrivate;

    private NewComponent(Builder builder) {
        this.organizationUuid = builder.organizationUuid;
        this.key = builder.key;
        this.branch = builder.branch;
        this.qualifier = builder.qualifier;
        this.name = builder.name;
        this.isPrivate = builder.isPrivate;
    }

    public static Builder newComponentBuilder() {
        return new Builder();
    }

    public String getOrganizationUuid() {
        return this.organizationUuid;
    }

    public String key() {
        return this.key;
    }

    public String name() {
        return this.name;
    }

    @CheckForNull
    public String branch() {
        return this.branch;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public static class Builder {
        private String organizationUuid;
        private String key;
        private String qualifier = "TRK";
        private String branch;
        private String name;
        private boolean isPrivate = false;

        private Builder() {
        }

        public Builder setOrganizationUuid(String organizationUuid) {
            this.organizationUuid = organizationUuid;
            return this;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setBranch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        public Builder setQualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setPrivate(boolean isPrivate) {
            this.isPrivate = isPrivate;
            return this;
        }

        public NewComponent build() {
            Objects.requireNonNull(this.organizationUuid, "organization uuid can't be null");
            ComponentValidator.checkComponentKey((String)this.key);
            ComponentValidator.checkComponentName((String)this.name);
            ComponentValidator.checkComponentQualifier((String)this.qualifier);
            return new NewComponent(this);
        }
    }
}

