/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.security.Authenticator;
import org.sonar.api.security.ExternalGroupsProvider;
import org.sonar.api.security.ExternalUsersProvider;
import org.sonar.api.security.SecurityRealm;
import org.sonar.api.security.UserDetails;
import org.sonar.api.server.authentication.Display;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.server.authentication.UserIdentity;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.UserIdentityAuthenticator;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;
import org.sonar.server.user.SecurityRealmFactory;

public class RealmAuthenticator
implements Startable {
    private static final Logger LOG = Loggers.get(RealmAuthenticator.class);
    private final Configuration config;
    private final SecurityRealmFactory securityRealmFactory;
    private final UserIdentityAuthenticator userIdentityAuthenticator;
    private final AuthenticationEvent authenticationEvent;
    private SecurityRealm realm;
    private Authenticator authenticator;
    private ExternalUsersProvider externalUsersProvider;
    private ExternalGroupsProvider externalGroupsProvider;

    public RealmAuthenticator(Configuration config, SecurityRealmFactory securityRealmFactory, UserIdentityAuthenticator userIdentityAuthenticator, AuthenticationEvent authenticationEvent) {
        this.config = config;
        this.securityRealmFactory = securityRealmFactory;
        this.userIdentityAuthenticator = userIdentityAuthenticator;
        this.authenticationEvent = authenticationEvent;
    }

    public void start() {
        this.realm = this.securityRealmFactory.getRealm();
        if (this.realm != null) {
            this.authenticator = Objects.requireNonNull(this.realm.doGetAuthenticator(), "No authenticator available");
            this.externalUsersProvider = Objects.requireNonNull(this.realm.getUsersProvider(), "No users provider available");
            this.externalGroupsProvider = this.realm.getGroupsProvider();
        }
    }

    public Optional<UserDto> authenticate(String userLogin, String userPassword, HttpServletRequest request, AuthenticationEvent.Method method) {
        if (this.realm == null) {
            return Optional.empty();
        }
        return Optional.of(this.doAuthenticate(this.getLogin(userLogin), userPassword, request, method));
    }

    private UserDto doAuthenticate(String userLogin, String userPassword, HttpServletRequest request, AuthenticationEvent.Method method) {
        try {
            ExternalUsersProvider.Context externalUsersProviderContext = new ExternalUsersProvider.Context(userLogin, request);
            UserDetails details = this.externalUsersProvider.doGetUserDetails(externalUsersProviderContext);
            if (details == null) {
                throw AuthenticationException.newBuilder().setSource(this.realmEventSource(method)).setLogin(userLogin).setMessage("No user details").build();
            }
            Authenticator.Context authenticatorContext = new Authenticator.Context(userLogin, userPassword, request);
            boolean status = this.authenticator.doAuthenticate(authenticatorContext);
            if (!status) {
                throw AuthenticationException.newBuilder().setSource(this.realmEventSource(method)).setLogin(userLogin).setMessage("Realm returned authenticate=false").build();
            }
            UserDto userDto = this.synchronize(userLogin, details, request, method);
            this.authenticationEvent.loginSuccess(request, userLogin, this.realmEventSource(method));
            return userDto;
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Error during authentication", (Throwable)e);
            throw AuthenticationException.newBuilder().setSource(this.realmEventSource(method)).setLogin(userLogin).setMessage(e.getMessage()).build();
        }
    }

    private AuthenticationEvent.Source realmEventSource(AuthenticationEvent.Method method) {
        return AuthenticationEvent.Source.realm(method, this.realm.getName());
    }

    private UserDto synchronize(String userLogin, UserDetails details, HttpServletRequest request, AuthenticationEvent.Method method) {
        String name = details.getName();
        UserIdentity.Builder userIdentityBuilder = UserIdentity.builder().setLogin(userLogin).setName(StringUtils.isEmpty((String)name) ? userLogin : name).setEmail(StringUtils.trimToNull((String)details.getEmail())).setProviderLogin(userLogin);
        if (this.externalGroupsProvider != null) {
            ExternalGroupsProvider.Context context = new ExternalGroupsProvider.Context(userLogin, request);
            Collection groups = this.externalGroupsProvider.doGetGroups(context);
            userIdentityBuilder.setGroups(new HashSet(groups));
        }
        return this.userIdentityAuthenticator.authenticate(userIdentityBuilder.build(), new ExternalIdentityProvider(), this.realmEventSource(method));
    }

    private String getLogin(String userLogin) {
        if (this.config.getBoolean("sonar.authenticator.downcase").orElse(false).booleanValue()) {
            return userLogin.toLowerCase(Locale.ENGLISH);
        }
        return userLogin;
    }

    public void stop() {
    }

    private static class ExternalIdentityProvider
    implements IdentityProvider {
        private ExternalIdentityProvider() {
        }

        public String getKey() {
            return "sonarqube";
        }

        public String getName() {
            return "sonarqube";
        }

        public Display getDisplay() {
            return null;
        }

        public boolean isEnabled() {
            return true;
        }

        public boolean allowsUsersToSignUp() {
            return true;
        }
    }
}

