/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.app;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import org.sonar.process.MinimumViableSystem;
import org.sonar.process.Monitored;
import org.sonar.process.ProcessEntryPoint;
import org.sonar.process.ProcessId;
import org.sonar.process.Props;
import org.sonar.process.sharedmemoryfile.DefaultProcessCommands;
import org.sonar.server.app.EmbeddedTomcat;
import org.sonar.server.app.WebServerProcessLogging;

public class WebServer
implements Monitored {
    public static final String PROPERTY_SHARED_PATH = "process.sharedDir";
    private final File sharedDir;
    private final EmbeddedTomcat tomcat;

    WebServer(Props props) {
        new MinimumViableSystem().checkWritableTempDir().checkRequiredJavaOptions((Map)ImmutableMap.of((Object)"file.encoding", (Object)"UTF-8"));
        this.sharedDir = WebServer.getSharedDir(props);
        this.tomcat = new EmbeddedTomcat(props);
    }

    private static File getSharedDir(Props props) {
        return props.nonNullValueAsFile(PROPERTY_SHARED_PATH);
    }

    public void start() {
        this.tomcat.start();
    }

    public Monitored.Status getStatus() {
        switch (this.tomcat.getStatus()) {
            case DOWN: {
                return Monitored.Status.DOWN;
            }
            case UP: {
                return this.isOperational() ? Monitored.Status.OPERATIONAL : Monitored.Status.UP;
            }
        }
        return Monitored.Status.FAILED;
    }

    private boolean isOperational() {
        try (DefaultProcessCommands processCommands = DefaultProcessCommands.secondary((File)this.sharedDir, (int)ProcessId.WEB_SERVER.getIpcIndex());){
            boolean bl = processCommands.isOperational();
            return bl;
        }
    }

    public void stop() {
        this.tomcat.terminate();
    }

    public void awaitStop() {
        this.tomcat.awaitTermination();
    }

    public static void main(String[] args) {
        ProcessEntryPoint entryPoint = ProcessEntryPoint.createForArguments((String[])args);
        Props props = entryPoint.getProps();
        new WebServerProcessLogging().configure(props);
        WebServer server = new WebServer(props);
        entryPoint.launch((Monitored)server);
    }
}

