/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook.ws;

import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.webhook.WebhookDeliveryLiteDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.user.UserSession;
import org.sonar.server.webhook.ws.WebhookWsSupport;
import org.sonar.server.webhook.ws.WebhooksWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Webhooks;

public class WebhookDeliveriesAction
implements WebhooksWsAction {
    private static final String PARAM_COMPONENT = "componentKey";
    private static final String PARAM_TASK = "ceTaskId";
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;

    public WebhookDeliveriesAction(DbClient dbClient, UserSession userSession, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("deliveries").setSince("6.2").setDescription("Get the recent deliveries for a specified project or Compute Engine task.<br/>Require 'Administer' permission on the related project.<br/>Note that additional information are returned by api/webhooks/delivery.").setResponseExample(Resources.getResource(this.getClass(), (String)"example-deliveries.json")).setHandler((RequestHandler)this);
        action.createParam(PARAM_COMPONENT).setDescription("Key of the project").setExampleValue((Object)"my-project");
        action.createParam(PARAM_TASK).setDescription("Id of the Compute Engine task").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        String ceTaskId = request.param(PARAM_TASK);
        String componentKey = request.param(PARAM_COMPONENT);
        Preconditions.checkArgument((boolean)(ceTaskId != null ^ componentKey != null), (String)"Either '%s' or '%s' must be provided", (Object[])new Object[]{PARAM_TASK, PARAM_COMPONENT});
        Data data = this.loadFromDatabase(ceTaskId, componentKey);
        data.ensureAdminPermission(this.userSession);
        data.writeTo(request, response);
    }

    private Data loadFromDatabase(@Nullable String ceTaskId, @Nullable String componentKey) {
        List deliveries;
        ComponentDto component = null;
        try (DbSession dbSession = this.dbClient.openSession(false);){
            if (componentKey != null) {
                component = this.componentFinder.getByKey(dbSession, componentKey);
                deliveries = this.dbClient.webhookDeliveryDao().selectOrderedByComponentUuid(dbSession, component.uuid());
            } else {
                deliveries = this.dbClient.webhookDeliveryDao().selectOrderedByCeTaskUuid(dbSession, ceTaskId);
                Optional<String> deliveredComponentUuid = deliveries.stream().map(WebhookDeliveryLiteDto::getComponentUuid).findFirst();
                if (deliveredComponentUuid.isPresent()) {
                    component = this.componentFinder.getByUuid(dbSession, deliveredComponentUuid.get());
                }
            }
        }
        return new Data(component, deliveries);
    }

    private static class Data {
        private final ComponentDto component;
        private final List<WebhookDeliveryLiteDto> deliveryDtos;

        Data(@Nullable ComponentDto component, List<WebhookDeliveryLiteDto> deliveries) {
            this.deliveryDtos = deliveries;
            this.component = deliveries.isEmpty() ? null : Objects.requireNonNull(component);
        }

        void ensureAdminPermission(UserSession userSession) {
            if (this.component != null) {
                userSession.checkComponentPermission("admin", this.component);
            }
        }

        void writeTo(Request request, Response response) {
            Webhooks.DeliveriesWsResponse.Builder responseBuilder = Webhooks.DeliveriesWsResponse.newBuilder();
            Webhooks.Delivery.Builder deliveryBuilder = Webhooks.Delivery.newBuilder();
            for (WebhookDeliveryLiteDto dto : this.deliveryDtos) {
                WebhookWsSupport.copyDtoToProtobuf(this.component, dto, deliveryBuilder);
                responseBuilder.addDeliveries(deliveryBuilder);
            }
            WsUtils.writeProtobuf((Message)responseBuilder.build(), request, response);
        }
    }
}

