/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usergroups;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.GroupDto;
import org.sonar.server.usergroups.DefaultGroupCreator;

public class DefaultGroupCreatorImpl
implements DefaultGroupCreator {
    static final String DEFAULT_GROUP_NAME = "Members";
    private final DbClient dbClient;

    public DefaultGroupCreatorImpl(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    @Override
    public GroupDto create(DbSession dbSession, String organizationUuid) {
        Optional existingMembersGroup = this.dbClient.groupDao().selectByName(dbSession, organizationUuid, DEFAULT_GROUP_NAME);
        Preconditions.checkArgument((!existingMembersGroup.isPresent() ? 1 : 0) != 0, (String)"The group '%s' already exist on organization '%s'", (Object[])new Object[]{DEFAULT_GROUP_NAME, organizationUuid});
        GroupDto defaultGroup = new GroupDto().setName(DEFAULT_GROUP_NAME).setDescription("All members of the organization").setOrganizationUuid(organizationUuid);
        this.dbClient.groupDao().insert(dbSession, defaultGroup);
        this.dbClient.organizationDao().setDefaultGroupId(dbSession, organizationUuid, defaultGroup);
        return defaultGroup;
    }
}

