/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.ws;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.protobuf.Message;
import javax.annotation.Nonnull;
import org.sonar.api.server.authentication.Display;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.authentication.IdentityProviderRepository;
import org.sonar.server.user.ws.UsersWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsUsers;

public class IdentityProvidersAction
implements UsersWsAction {
    private final IdentityProviderRepository identityProviderRepository;

    public IdentityProvidersAction(IdentityProviderRepository identityProviderRepository) {
        this.identityProviderRepository = identityProviderRepository;
    }

    public void define(WebService.NewController context) {
        context.createAction("identity_providers").setDescription("List the external identity providers").setResponseExample(this.getClass().getResource("identity_providers-example.json")).setSince("5.5").setInternal(true).setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) throws Exception {
        WsUtils.writeProtobuf((Message)this.buildResponse(), request, response);
    }

    private WsUsers.IdentityProvidersWsResponse buildResponse() {
        WsUsers.IdentityProvidersWsResponse.Builder response = WsUsers.IdentityProvidersWsResponse.newBuilder();
        response.addAllIdentityProviders((Iterable)Lists.transform(this.identityProviderRepository.getAllEnabledAndSorted(), (Function)IdentityProviderToWsResponse.INSTANCE));
        return response.build();
    }

    private static enum IdentityProviderToWsResponse implements Function<IdentityProvider, WsUsers.IdentityProvider>
    {
        INSTANCE;


        public WsUsers.IdentityProvider apply(@Nonnull IdentityProvider input) {
            WsUsers.IdentityProvider.Builder builder = WsUsers.IdentityProvider.newBuilder().setKey(input.getKey()).setName(input.getName());
            Display display = input.getDisplay();
            builder.setIconPath(display.getIconPath()).setBackgroundColor(display.getBackgroundColor());
            return builder.build();
        }
    }
}

