/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.GroupDto;
import org.sonar.db.user.GroupMembershipDto;
import org.sonar.db.user.GroupMembershipQuery;
import org.sonar.db.user.UserDto;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.ws.UsersWsAction;
import org.sonar.server.usergroups.DefaultGroupFinder;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsUsers;
import org.sonarqube.ws.client.user.GroupsRequest;

public class GroupsAction
implements UsersWsAction {
    private static final int MAX_PAGE_SIZE = 500;
    private final DbClient dbClient;
    private final UserSession userSession;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final DefaultGroupFinder defaultGroupFinder;

    public GroupsAction(DbClient dbClient, UserSession userSession, DefaultOrganizationProvider defaultOrganizationProvider, DefaultGroupFinder defaultGroupFinder) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.defaultGroupFinder = defaultGroupFinder;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("groups").setDescription("Lists the groups a user belongs to. <br/>Requires Administer System permission.").setHandler((RequestHandler)this).setResponseExample(this.getClass().getResource("groups-example.json")).addSelectionModeParam().addSearchQuery("users", new String[]{"group names"}).addPagingParams(25).setChangelog(new Change[]{new Change("6.4", "Paging response fields moved to a Paging object"), new Change("6.4", "'default' response field has been added")}).setSince("5.2");
        action.createParam("login").setDescription("A user login").setExampleValue((Object)"admin").setRequired(true);
        action.createParam("organization").setDescription("Organization key").setExampleValue((Object)"my-org").setInternal(true).setSince("6.4");
    }

    public void handle(Request request, Response response) throws Exception {
        WsUsers.GroupsWsResponse groupsWsResponse = this.doHandle(GroupsAction.toGroupsRequest(request));
        WsUtils.writeProtobuf((Message)groupsWsResponse, request, response);
    }

    private WsUsers.GroupsWsResponse doHandle(GroupsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.findOrganizationByKey(dbSession, request.getOrganization());
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER, organization);
            String login = request.getLogin();
            GroupMembershipQuery query = GroupMembershipQuery.builder().organizationUuid(organization.getUuid()).groupSearch(request.getQuery()).membership(GroupsAction.getMembership(request.getSelected())).pageIndex(request.getPage()).pageSize(request.getPageSize()).build();
            UserDto user = WsUtils.checkFound(this.dbClient.userDao().selectActiveUserByLogin(dbSession, login), "Unknown user: %s", login);
            int total = this.dbClient.groupMembershipDao().countGroups(dbSession, query, user.getId());
            Paging paging = Paging.forPageIndex((int)query.pageIndex()).withPageSize(query.pageSize()).andTotal(total);
            List groups = this.dbClient.groupMembershipDao().selectGroups(dbSession, query, user.getId(), paging.offset(), query.pageSize());
            WsUsers.GroupsWsResponse groupsWsResponse = GroupsAction.buildResponse(groups, this.defaultGroupFinder.findDefaultGroup(dbSession, organization.getUuid()), paging);
            return groupsWsResponse;
        }
    }

    private OrganizationDto findOrganizationByKey(DbSession dbSession, @Nullable String key) {
        String effectiveKey = key == null ? this.defaultOrganizationProvider.get().getKey() : key;
        Optional org = this.dbClient.organizationDao().selectByKey(dbSession, effectiveKey);
        WsUtils.checkFoundWithOptional(org, "No organization with key '%s'", key);
        return (OrganizationDto)org.get();
    }

    private static GroupsRequest toGroupsRequest(Request request) {
        int pageSize = request.mandatoryParamAsInt("ps");
        Preconditions.checkArgument((pageSize <= 500 ? 1 : 0) != 0, (String)"The '%s' parameter must be less than %s", (Object[])new Object[]{"ps", 500});
        return GroupsRequest.builder().setLogin(request.mandatoryParam("login")).setOrganization(request.param("organization")).setSelected(request.mandatoryParam("selected")).setQuery(request.param("q")).setPage(Integer.valueOf(request.mandatoryParamAsInt("p"))).setPageSize(Integer.valueOf(pageSize)).build();
    }

    private static String getMembership(String selected) {
        WebService.SelectionMode selectionMode = WebService.SelectionMode.fromParam((String)selected);
        String membership = "ANY";
        if (WebService.SelectionMode.SELECTED == selectionMode) {
            membership = "IN";
        } else if (WebService.SelectionMode.DESELECTED == selectionMode) {
            membership = "OUT";
        }
        return membership;
    }

    private static WsUsers.GroupsWsResponse buildResponse(List<GroupMembershipDto> groups, GroupDto defaultGroup, Paging paging) {
        WsUsers.GroupsWsResponse.Builder responseBuilder = WsUsers.GroupsWsResponse.newBuilder();
        groups.forEach(group -> responseBuilder.addGroups(GroupsAction.toWsGroup(group, defaultGroup)));
        responseBuilder.getPagingBuilder().setPageIndex(paging.pageIndex()).setPageSize(paging.pageSize()).setTotal(paging.total()).build();
        return responseBuilder.build();
    }

    private static WsUsers.GroupsWsResponse.Group toWsGroup(GroupMembershipDto group, GroupDto defaultGroup) {
        WsUsers.GroupsWsResponse.Group.Builder groupBuilder = WsUsers.GroupsWsResponse.Group.newBuilder().setId(group.getId().longValue()).setName(group.getName()).setSelected(group.getUserId() != null).setDefault(defaultGroup.getId().longValue() == group.getId().longValue());
        Protobuf.setNullable((Object)group.getDescription(), arg_0 -> ((WsUsers.GroupsWsResponse.Group.Builder)groupBuilder).setDescription(arg_0));
        return groupBuilder.build();
    }
}

