/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.ws;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.UserDto;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.ws.UsersWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsUsers;

public class CurrentAction
implements UsersWsAction {
    private final UserSession userSession;
    private final DbClient dbClient;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public CurrentAction(UserSession userSession, DbClient dbClient, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    public void define(WebService.NewController context) {
        context.createAction("current").setDescription("Get the details of the current authenticated user.").setHandler((RequestHandler)this).setInternal(true).setResponseExample(this.getClass().getResource("current-example.json")).setSince("5.2").setChangelog(new Change[]{new Change("6.5", "showOnboardingTutorial is now returned in the response")});
    }

    public void handle(Request request, Response response) throws Exception {
        if (this.userSession.isLoggedIn()) {
            try (DbSession dbSession = this.dbClient.openSession(false);){
                WsUtils.writeProtobuf((Message)this.toWsResponse(dbSession, this.userSession.getLogin()), request, response);
            }
        } else {
            WsUtils.writeProtobuf((Message)WsUsers.CurrentWsResponse.newBuilder().setIsLoggedIn(false).setPermissions(WsUsers.CurrentWsResponse.Permissions.newBuilder().addAllGlobal(this.getGlobalPermissions()).build()).build(), request, response);
        }
    }

    private WsUsers.CurrentWsResponse toWsResponse(DbSession dbSession, String userLogin) {
        UserDto user = this.dbClient.userDao().selectActiveUserByLogin(dbSession, userLogin);
        Preconditions.checkState((user != null ? 1 : 0) != 0, (String)"User login '%s' cannot be found", (Object[])new Object[]{userLogin});
        Collection groups = this.dbClient.groupMembershipDao().selectGroupsByLogins(dbSession, Collections.singletonList(userLogin)).get((Object)userLogin);
        WsUsers.CurrentWsResponse.Builder builder = WsUsers.CurrentWsResponse.newBuilder().setIsLoggedIn(true).setLogin(user.getLogin()).setName(user.getName()).setLocal(user.isLocal()).addAllGroups((Iterable)groups).addAllScmAccounts((Iterable)user.getScmAccountsAsList()).setPermissions(WsUsers.CurrentWsResponse.Permissions.newBuilder().addAllGlobal(this.getGlobalPermissions()).build()).setShowOnboardingTutorial(!user.isOnboarded());
        Protobuf.setNullable((Object)Strings.emptyToNull((String)user.getEmail()), arg_0 -> ((WsUsers.CurrentWsResponse.Builder)builder).setEmail(arg_0));
        Protobuf.setNullable((Object)user.getExternalIdentity(), arg_0 -> ((WsUsers.CurrentWsResponse.Builder)builder).setExternalIdentity(arg_0));
        Protobuf.setNullable((Object)user.getExternalIdentityProvider(), arg_0 -> ((WsUsers.CurrentWsResponse.Builder)builder).setExternalProvider(arg_0));
        return builder.build();
    }

    private List<String> getGlobalPermissions() {
        String defaultOrganizationUuid = this.defaultOrganizationProvider.get().getUuid();
        return OrganizationPermission.all().filter(permission -> this.userSession.hasPermission((OrganizationPermission)permission, defaultOrganizationUuid)).map(OrganizationPermission::getKey).collect(Collectors.toList());
    }
}

