/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.server.user.ExternalIdentity;

public class NewUser {
    private String login;
    private String password;
    private String name;
    private String email;
    private List<String> scmAccounts;
    private ExternalIdentity externalIdentity;

    private NewUser(Builder builder) {
        this.login = builder.login;
        this.password = builder.password;
        this.name = builder.name;
        this.email = builder.email;
        this.scmAccounts = builder.scmAccounts;
        this.externalIdentity = builder.externalIdentity;
    }

    public String login() {
        return this.login;
    }

    public String name() {
        return this.name;
    }

    @CheckForNull
    public String email() {
        return this.email;
    }

    public NewUser setEmail(@Nullable String email) {
        this.email = email;
        return this;
    }

    public List<String> scmAccounts() {
        return this.scmAccounts;
    }

    public NewUser setScmAccounts(List<String> scmAccounts) {
        this.scmAccounts = scmAccounts;
        return this;
    }

    @Nullable
    public String password() {
        return this.password;
    }

    public NewUser setPassword(@Nullable String password) {
        this.password = password;
        return this;
    }

    @Nullable
    public ExternalIdentity externalIdentity() {
        return this.externalIdentity;
    }

    public NewUser setExternalIdentity(@Nullable ExternalIdentity externalIdentity) {
        this.externalIdentity = externalIdentity;
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String login;
        private String name;
        private String email;
        private List<String> scmAccounts = new ArrayList<String>();
        private String password;
        private ExternalIdentity externalIdentity;

        public Builder setLogin(String login) {
            this.login = login;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setEmail(@Nullable String email) {
            this.email = email;
            return this;
        }

        public Builder setScmAccounts(List<String> scmAccounts) {
            this.scmAccounts = scmAccounts;
            return this;
        }

        public Builder setPassword(@Nullable String password) {
            this.password = password;
            return this;
        }

        public Builder setExternalIdentity(@Nullable ExternalIdentity externalIdentity) {
            this.externalIdentity = externalIdentity;
            return this;
        }

        public NewUser build() {
            Preconditions.checkState((this.externalIdentity == null || this.password == null ? 1 : 0) != 0, (Object)"Password should not be set with an external identity");
            return new NewUser(this);
        }
    }
}

