/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ui.ws;

import org.sonar.api.config.Configuration;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.api.web.page.Page;
import org.sonar.server.ui.PageRepository;
import org.sonar.server.ui.ws.NavigationWsAction;
import org.sonar.server.user.UserSession;

public class SettingsAction
implements NavigationWsAction {
    private final PageRepository pageRepository;
    private final Configuration config;
    private final UserSession userSession;

    public SettingsAction(PageRepository pageRepository, Configuration config, UserSession userSession) {
        this.pageRepository = pageRepository;
        this.config = config;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        context.createAction("settings").setDescription("Get configuration information for the settings page:<ul>  <li>List plugin-contributed pages</li>  <li>Show update center (or not)</li></ul>").setHandler((RequestHandler)this).setInternal(true).setResponseExample(this.getClass().getResource("settings-example.json")).setSince("5.2");
    }

    public void handle(Request request, Response response) throws Exception {
        boolean isSysAdmin = this.userSession.isSystemAdministrator();
        try (JsonWriter json = response.newJsonWriter();){
            json.beginObject();
            json.prop("showUpdateCenter", isSysAdmin && this.config.getBoolean("sonar.updatecenter.activate").orElse(false) != false);
            json.name("extensions").beginArray();
            if (isSysAdmin) {
                for (Page page : this.pageRepository.getGlobalPages(true)) {
                    json.beginObject().prop("key", page.getKey()).prop("name", page.getName()).endObject();
                }
            }
            json.endArray().endObject();
        }
    }
}

