/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ui;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.sonar.api.Startable;
import org.sonar.api.server.ServerSide;
import org.sonar.api.web.page.Context;
import org.sonar.api.web.page.Page;
import org.sonar.api.web.page.PageDefinition;
import org.sonar.core.platform.PluginRepository;
import org.sonar.core.util.stream.MoreCollectors;

@ServerSide
public class PageRepository
implements Startable {
    private static final Splitter PAGE_KEY_SPLITTER = Splitter.on((String)"/").omitEmptyStrings();
    private final PluginRepository pluginRepository;
    private final List<PageDefinition> definitions;
    private List<Page> pages;

    public PageRepository(PluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
        this.definitions = Collections.emptyList();
    }

    public PageRepository(PluginRepository pluginRepository, PageDefinition[] pageDefinitions) {
        this.pluginRepository = pluginRepository;
        this.definitions = ImmutableList.copyOf((Object[])pageDefinitions);
    }

    private static Consumer<Page> checkWellFormed() {
        return page -> {
            boolean isWellFormed = PAGE_KEY_SPLITTER.splitToList((CharSequence)page.getKey()).size() == 2;
            Preconditions.checkState((boolean)isWellFormed, (String)"Page '%s' with key '%s' does not respect the format plugin_key/extension_point_key (ex: governance/project_dump)", (Object[])new Object[]{page.getName(), page.getKey()});
        };
    }

    public void start() {
        Context context = new Context();
        this.definitions.forEach(definition -> definition.define(context));
        this.pages = (List)context.getPages().stream().peek(PageRepository.checkWellFormed()).peek(this.checkPluginExists()).sorted(Comparator.comparing(Page::getKey)).collect(MoreCollectors.toList());
    }

    public void stop() {
    }

    public List<Page> getGlobalPages(boolean isAdmin) {
        return this.getPages(Page.Scope.GLOBAL, isAdmin, null);
    }

    public List<Page> getOrganizationPages(boolean isAdmin) {
        return this.getPages(Page.Scope.ORGANIZATION, isAdmin, null);
    }

    public List<Page> getComponentPages(boolean isAdmin, String qualifierKey) {
        Page.Qualifier qualifier = Page.Qualifier.fromKey((String)qualifierKey);
        return qualifier == null ? Collections.emptyList() : this.getPages(Page.Scope.COMPONENT, isAdmin, qualifier);
    }

    private List<Page> getPages(Page.Scope scope, boolean isAdmin, @Nullable Page.Qualifier qualifier) {
        return (List)this.getAllPages().stream().filter(p -> p.getScope().equals((Object)scope)).filter(p -> p.isAdmin() == isAdmin).filter(p -> !Page.Scope.COMPONENT.equals((Object)p.getScope()) || p.getComponentQualifiers().contains(qualifier)).collect(MoreCollectors.toList());
    }

    @VisibleForTesting
    List<Page> getAllPages() {
        return Objects.requireNonNull(this.pages, "Pages haven't been initialized yet");
    }

    private Consumer<Page> checkPluginExists() {
        return page -> {
            String plugin = (String)PAGE_KEY_SPLITTER.splitToList((CharSequence)page.getKey()).get(0);
            boolean pluginExists = this.pluginRepository.hasPlugin(plugin);
            Preconditions.checkState((boolean)pluginExists, (String)"Page '%s' references plugin '%s' that does not exist", (Object[])new Object[]{page.getName(), plugin});
        };
    }
}

