/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.test.index;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.xcontent.XContentType;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.ResultSetIterator;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.db.source.FileSourceDto;
import org.sonar.server.es.EsUtils;
import org.sonar.server.source.index.FileSourcesUpdaterHelper;
import org.sonar.server.test.index.TestIndexDefinition;

public class TestResultSetIterator
extends ResultSetIterator<FileSourcesUpdaterHelper.Row> {
    private TestResultSetIterator(PreparedStatement stmt) throws SQLException {
        super(stmt);
    }

    public static TestResultSetIterator create(DbClient dbClient, DbSession session, @Nullable String projectUuid) {
        try {
            return new TestResultSetIterator(FileSourcesUpdaterHelper.preparedStatementToSelectFileSources(dbClient, session, "TEST", projectUuid));
        }
        catch (SQLException e) {
            throw new IllegalStateException("Fail to prepare SQL request to select all tests", e);
        }
    }

    protected FileSourcesUpdaterHelper.Row read(ResultSet rs) throws SQLException {
        String projectUuid = rs.getString(1);
        String fileUuid = rs.getString(2);
        Date updatedAt = new Date(rs.getLong(3));
        List<DbFileSources.Test> tests = TestResultSetIterator.parseData(fileUuid, rs.getBinaryStream(4));
        return TestResultSetIterator.toRow(projectUuid, fileUuid, updatedAt, tests);
    }

    private static List<DbFileSources.Test> parseData(String fileUuid, @Nullable InputStream dataInput) {
        List tests = Collections.emptyList();
        if (dataInput != null) {
            try {
                tests = FileSourceDto.decodeTestData((InputStream)dataInput);
            }
            catch (Exception e) {
                Loggers.get(TestResultSetIterator.class).warn(String.format("Invalid file_sources.binary_data on row with file_uuid='%s', test file will be ignored", fileUuid), (Throwable)e);
            }
        }
        return tests;
    }

    public static FileSourcesUpdaterHelper.Row toRow(String projectUuid, String fileUuid, Date updatedAt, List<DbFileSources.Test> tests) {
        FileSourcesUpdaterHelper.Row result = new FileSourcesUpdaterHelper.Row(projectUuid, fileUuid, updatedAt.getTime());
        for (DbFileSources.Test test : tests) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try (JsonWriter writer = JsonWriter.of((Writer)new OutputStreamWriter((OutputStream)bytes, StandardCharsets.UTF_8)).setSerializeNulls(true);){
                writer.beginObject();
                writer.prop("projectUuid", projectUuid);
                writer.prop("fileUuid", fileUuid);
                writer.prop("testUuid", test.getUuid());
                writer.prop("name", test.getName());
                writer.prop("status", test.hasStatus() ? test.getStatus().toString() : null);
                writer.prop("durationInMs", test.hasExecutionTimeMs() ? Long.valueOf(test.getExecutionTimeMs()) : null);
                writer.prop("message", test.hasMsg() ? test.getMsg() : null);
                writer.prop("stacktrace", test.hasStacktrace() ? test.getStacktrace() : null);
                writer.prop("updatedAt", EsUtils.formatDateTime(updatedAt));
                writer.name("coveredFiles");
                writer.beginArray();
                for (DbFileSources.Test.CoveredFile coveredFile : test.getCoveredFileList()) {
                    writer.beginObject();
                    writer.prop("sourceFileUuid", coveredFile.getFileUuid());
                    writer.name("coveredLines").valueObject((Object)coveredFile.getCoveredLineList());
                    writer.endObject();
                }
                writer.endArray();
                writer.endObject();
            }
            byte[] jsonDoc = bytes.toByteArray();
            UpdateRequest updateRequest = new UpdateRequest(TestIndexDefinition.INDEX_TYPE_TEST.getIndex(), TestIndexDefinition.INDEX_TYPE_TEST.getType(), test.getUuid()).routing(projectUuid).doc(jsonDoc, XContentType.JSON).upsert(jsonDoc, XContentType.JSON);
            result.getUpdateRequests().add(updateRequest);
        }
        return result;
    }
}

