/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.test.index;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.sonar.api.utils.System2;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.es.SearchResult;
import org.sonar.server.test.index.CoveredFileDoc;
import org.sonar.server.test.index.TestDoc;
import org.sonar.server.test.index.TestIndexDefinition;

public class TestIndex {
    private final EsClient client;
    private final System2 system2;

    public TestIndex(EsClient client, System2 system2) {
        this.client = client;
        this.system2 = system2;
    }

    public List<CoveredFileDoc> coveredFiles(String testUuid) {
        ArrayList<CoveredFileDoc> coveredFiles = new ArrayList<CoveredFileDoc>();
        for (SearchHit hit : ((SearchResponse)this.client.prepareSearch(TestIndexDefinition.INDEX_TYPE_TEST).setSize(1).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchAllQuery()).filter((QueryBuilder)QueryBuilders.termQuery((String)"testUuid", (String)testUuid))).get()).getHits().getHits()) {
            coveredFiles.addAll(new TestDoc(hit.getSourceAsMap()).coveredFiles());
        }
        return coveredFiles;
    }

    public SearchResult<TestDoc> searchByTestFileUuid(String testFileUuid, SearchOptions searchOptions) {
        SearchRequestBuilder searchRequest = this.client.prepareSearch(TestIndexDefinition.INDEX_TYPE_TEST).setSize(searchOptions.getLimit()).setFrom(searchOptions.getOffset()).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchAllQuery()).filter((QueryBuilder)QueryBuilders.termQuery((String)"fileUuid", (String)testFileUuid)));
        return new SearchResult<TestDoc>((SearchResponse)searchRequest.get(), TestDoc::new, this.system2.getDefaultTimeZone());
    }

    public SearchResult<TestDoc> searchBySourceFileUuidAndLineNumber(String sourceFileUuid, int lineNumber, SearchOptions searchOptions) {
        SearchRequestBuilder searchRequest = this.client.prepareSearch(TestIndexDefinition.INDEX_TYPE_TEST).setSize(searchOptions.getLimit()).setFrom(searchOptions.getOffset()).setQuery((QueryBuilder)QueryBuilders.nestedQuery((String)"coveredFiles", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"coveredFiles.sourceFileUuid", (String)sourceFileUuid)).must((QueryBuilder)QueryBuilders.termQuery((String)"coveredFiles.coveredLines", (int)lineNumber)), (ScoreMode)ScoreMode.Avg));
        return new SearchResult<TestDoc>((SearchResponse)searchRequest.get(), TestDoc::new, this.system2.getDefaultTimeZone());
    }

    public TestDoc getByTestUuid(String testUuid) {
        Optional<TestDoc> testDoc = this.getNullableByTestUuid(testUuid);
        if (testDoc.isPresent()) {
            return (TestDoc)testDoc.get();
        }
        throw new IllegalStateException(String.format("Test id '%s' not found", testUuid));
    }

    public Optional<TestDoc> getNullableByTestUuid(String testUuid) {
        SearchHit[] hits = ((SearchResponse)this.client.prepareSearch(TestIndexDefinition.INDEX_TYPE_TEST).setSize(1).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchAllQuery()).filter((QueryBuilder)QueryBuilders.termQuery((String)"testUuid", (String)testUuid))).get()).getHits().getHits();
        if (hits.length > 0) {
            return Optional.of((Object)new TestDoc(hits[0].getSourceAsMap()));
        }
        return Optional.absent();
    }

    public SearchResult<TestDoc> searchByTestUuid(String testUuid, SearchOptions searchOptions) {
        SearchRequestBuilder searchRequest = this.client.prepareSearch(TestIndexDefinition.INDEX_TYPE_TEST).setSize(searchOptions.getLimit()).setFrom(searchOptions.getOffset()).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchAllQuery()).filter((QueryBuilder)QueryBuilders.termQuery((String)"testUuid", (String)testUuid)));
        return new SearchResult<TestDoc>((SearchResponse)searchRequest.get(), TestDoc::new, this.system2.getDefaultTimeZone());
    }
}

