/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.setting.ws;

import com.google.protobuf.Message;
import org.sonar.api.config.Encryption;
import org.sonar.api.config.Settings;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.setting.ws.SettingsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Settings;

public class EncryptAction
implements SettingsWsAction {
    private final UserSession userSession;
    private final Settings settings;

    public EncryptAction(UserSession userSession, Settings settings) {
        this.userSession = userSession;
        this.settings = settings;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("encrypt").setDescription("Encrypt a setting value.<br>Requires 'Administer System' permission.").setSince("6.1").setHandler((RequestHandler)this).setInternal(true).setResponseExample(this.getClass().getResource("encrypt-example.json"));
        action.createParam("value").setRequired(true).setDescription("Setting value to encrypt").setExampleValue((Object)"my value");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkIsSystemAdministrator();
        String value = request.mandatoryParam("value");
        WsUtils.checkRequest(!value.isEmpty(), "Parameter '%s' must not be empty", "value");
        Encryption encryption = this.settings.getEncryption();
        WsUtils.checkRequest(encryption.hasSecretKey(), "No secret key available", new Object[0]);
        String encryptedValue = encryption.encrypt(value);
        WsUtils.writeProtobuf((Message)EncryptAction.toEncryptWsResponse(encryptedValue), request, response);
    }

    private static Settings.EncryptWsResponse toEncryptWsResponse(String encryptedValue) {
        return Settings.EncryptWsResponse.newBuilder().setEncryptedValue(encryptedValue).build();
    }
}

