/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.index.IndexRequest;
import org.sonar.api.rule.RuleKey;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.es.EsQueueDto;
import org.sonar.db.es.RuleExtensionId;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.rule.RuleExtensionForIndexingDto;
import org.sonar.db.rule.RuleForIndexingDto;
import org.sonar.server.es.BulkIndexer;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.IndexingListener;
import org.sonar.server.es.IndexingResult;
import org.sonar.server.es.OneToOneResilientIndexingListener;
import org.sonar.server.es.ResilientIndexer;
import org.sonar.server.rule.index.RuleDoc;
import org.sonar.server.rule.index.RuleExtensionDoc;
import org.sonar.server.rule.index.RuleExtensionScope;
import org.sonar.server.rule.index.RuleIndexDefinition;

public class RuleIndexer
implements ResilientIndexer {
    private final EsClient esClient;
    private final DbClient dbClient;

    public RuleIndexer(EsClient esClient, DbClient dbClient) {
        this.esClient = esClient;
        this.dbClient = dbClient;
    }

    @Override
    public Set<IndexType> getIndexTypes() {
        return ImmutableSet.of((Object)RuleIndexDefinition.INDEX_TYPE_RULE, (Object)RuleIndexDefinition.INDEX_TYPE_RULE_EXTENSION);
    }

    @Override
    public void indexOnStartup(Set<IndexType> uninitializedIndexTypes) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            BulkIndexer bulk = this.createBulkIndexer(BulkIndexer.Size.LARGE, IndexingListener.FAIL_ON_ERROR);
            bulk.start();
            if (uninitializedIndexTypes.contains(RuleIndexDefinition.INDEX_TYPE_RULE)) {
                this.dbClient.ruleDao().scrollIndexingRules(dbSession, dto -> {
                    bulk.add(RuleIndexer.newRuleDocIndexRequest(dto));
                    bulk.add(RuleIndexer.newRuleExtensionDocIndexRequest(dto));
                });
            }
            if (uninitializedIndexTypes.contains(RuleIndexDefinition.INDEX_TYPE_RULE_EXTENSION)) {
                this.dbClient.ruleDao().scrollIndexingRuleExtensions(dbSession, dto -> bulk.add(RuleIndexer.newRuleExtensionDocIndexRequest(dto)));
            }
            bulk.stop();
        }
    }

    public void commitAndIndex(DbSession dbSession, RuleKey ruleKey) {
        this.commitAndIndex(dbSession, Collections.singletonList(ruleKey));
    }

    public void commitAndIndex(DbSession dbSession, Collection<RuleKey> ruleKeys) {
        List items = (List)ruleKeys.stream().map(RuleIndexer::createQueueDtoForRule).collect(MoreCollectors.toArrayList());
        this.dbClient.esQueueDao().insert(dbSession, (Collection)items);
        dbSession.commit();
        this.postCommit(dbSession, items);
    }

    public void commitAndIndex(DbSession dbSession, RuleKey ruleKey, OrganizationDto organization) {
        List<EsQueueDto> items = Arrays.asList(RuleIndexer.createQueueDtoForRule(ruleKey), RuleIndexer.createQueueDtoForRuleExtension(ruleKey, organization));
        this.dbClient.esQueueDao().insert(dbSession, items);
        dbSession.commit();
        this.postCommit(dbSession, items);
    }

    private void postCommit(DbSession dbSession, List<EsQueueDto> items) {
        this.index(dbSession, items);
    }

    @Override
    public IndexingResult index(DbSession dbSession, Collection<EsQueueDto> items) {
        IndexingResult result = new IndexingResult();
        if (!items.isEmpty()) {
            ListMultimap<IndexType, EsQueueDto> itemsByType = RuleIndexer.groupItemsByType(items);
            result.add(this.doIndexRules(dbSession, itemsByType.get((Object)RuleIndexDefinition.INDEX_TYPE_RULE)));
            result.add(this.doIndexRuleExtensions(dbSession, itemsByType.get((Object)RuleIndexDefinition.INDEX_TYPE_RULE_EXTENSION)));
        }
        return result;
    }

    private IndexingResult doIndexRules(DbSession dbSession, List<EsQueueDto> items) {
        BulkIndexer bulkIndexer = this.createBulkIndexer(BulkIndexer.Size.REGULAR, new OneToOneResilientIndexingListener(this.dbClient, dbSession, items));
        bulkIndexer.start();
        Set ruleKeys = (Set)items.stream().map(i -> RuleKey.parse((String)i.getDocId())).collect(MoreCollectors.toHashSet((int)items.size()));
        this.dbClient.ruleDao().scrollIndexingRulesByKeys(dbSession, (Collection)ruleKeys, r -> {
            bulkIndexer.add(RuleIndexer.newRuleDocIndexRequest(r));
            bulkIndexer.add(RuleIndexer.newRuleExtensionDocIndexRequest(r));
            ruleKeys.remove(r.getRuleKey());
        });
        ruleKeys.forEach(ruleKey -> {
            bulkIndexer.addDeletion(RuleIndexDefinition.INDEX_TYPE_RULE, ruleKey.toString(), ruleKey.toString());
            bulkIndexer.addDeletion(RuleIndexDefinition.INDEX_TYPE_RULE_EXTENSION, RuleExtensionDoc.idOf(ruleKey, RuleExtensionScope.system()), ruleKey.toString());
        });
        return bulkIndexer.stop();
    }

    private IndexingResult doIndexRuleExtensions(DbSession dbSession, List<EsQueueDto> items) {
        BulkIndexer bulkIndexer = this.createBulkIndexer(BulkIndexer.Size.REGULAR, new OneToOneResilientIndexingListener(this.dbClient, dbSession, items));
        bulkIndexer.start();
        Set docIds = (Set)items.stream().map(RuleIndexer::explodeRuleExtensionDocId).collect(MoreCollectors.toHashSet((int)items.size()));
        this.dbClient.ruleDao().scrollIndexingRuleExtensionsByIds(dbSession, (Collection)docIds, r -> {
            RuleExtensionId docId = new RuleExtensionId(r.getOrganizationUuid(), r.getPluginName(), r.getPluginRuleKey());
            docIds.remove(docId);
            bulkIndexer.add(RuleIndexer.newRuleExtensionDocIndexRequest(r));
        });
        docIds.forEach(docId -> {
            RuleKey ruleKey = RuleKey.of((String)docId.getRepositoryName(), (String)docId.getRuleKey());
            bulkIndexer.addDeletion(RuleIndexDefinition.INDEX_TYPE_RULE_EXTENSION, docId.getId(), ruleKey.toString());
        });
        return bulkIndexer.stop();
    }

    private static IndexRequest newRuleDocIndexRequest(RuleForIndexingDto ruleForIndexingDto) {
        RuleDoc doc = RuleDoc.of(ruleForIndexingDto);
        return new IndexRequest(RuleIndexDefinition.INDEX_TYPE_RULE.getIndex(), RuleIndexDefinition.INDEX_TYPE_RULE.getType()).id(doc.key().toString()).routing(doc.getRouting()).source(doc.getFields());
    }

    private static IndexRequest newRuleExtensionDocIndexRequest(RuleForIndexingDto ruleForIndexingDto) {
        RuleExtensionDoc ruleExtensionDoc = RuleExtensionDoc.of(ruleForIndexingDto);
        return new IndexRequest(RuleIndexDefinition.INDEX_TYPE_RULE_EXTENSION.getIndex(), RuleIndexDefinition.INDEX_TYPE_RULE_EXTENSION.getType()).id(ruleExtensionDoc.getId()).routing(ruleExtensionDoc.getRouting()).parent(ruleExtensionDoc.getParent()).source(ruleExtensionDoc.getFields());
    }

    private static IndexRequest newRuleExtensionDocIndexRequest(RuleExtensionForIndexingDto ruleExtensionForIndexingDto) {
        RuleExtensionDoc doc = RuleExtensionDoc.of(ruleExtensionForIndexingDto);
        return new IndexRequest(RuleIndexDefinition.INDEX_TYPE_RULE_EXTENSION.getIndex(), RuleIndexDefinition.INDEX_TYPE_RULE_EXTENSION.getType()).id(doc.getId()).routing(doc.getRouting()).parent(doc.getParent()).source(doc.getFields());
    }

    private BulkIndexer createBulkIndexer(BulkIndexer.Size bulkSize, IndexingListener listener) {
        return new BulkIndexer(this.esClient, RuleIndexDefinition.INDEX_TYPE_RULE, bulkSize, listener);
    }

    private static ListMultimap<IndexType, EsQueueDto> groupItemsByType(Collection<EsQueueDto> items) {
        return (ListMultimap)items.stream().collect(MoreCollectors.index(i -> IndexType.parse(i.getDocType())));
    }

    private static RuleExtensionId explodeRuleExtensionDocId(EsQueueDto esQueueDto) {
        Preconditions.checkArgument((boolean)Objects.equals(esQueueDto.getDocType(), "rules/ruleExtension"));
        return new RuleExtensionId(esQueueDto.getDocId());
    }

    private static EsQueueDto createQueueDtoForRule(RuleKey ruleKey) {
        return EsQueueDto.create((String)"rules/rule", (String)ruleKey.toString(), null, (String)ruleKey.toString());
    }

    private static EsQueueDto createQueueDtoForRuleExtension(RuleKey ruleKey, OrganizationDto organization) {
        String docId = RuleExtensionDoc.idOf(ruleKey, RuleExtensionScope.organization(organization));
        return EsQueueDto.create((String)"rules/ruleExtension", (String)docId, null, (String)ruleKey.toString());
    }
}

