/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule;

import com.google.common.collect.Sets;
import java.util.Set;
import org.sonar.api.server.rule.RuleTagFormat;
import org.sonar.db.rule.RuleDto;

class RuleTagHelper {
    private RuleTagHelper() {
    }

    static boolean applyTags(RuleDto rule, Set<String> tags) {
        for (String tag : tags) {
            RuleTagFormat.validate((String)tag);
        }
        Set initialTags = rule.getTags();
        Set systemTags = rule.getSystemTags();
        Set withoutSystemTags = Sets.filter(tags, input -> input != null && !systemTags.contains(input));
        rule.setTags(withoutSystemTags);
        return withoutSystemTags.size() != initialTags.size() || !withoutSystemTags.containsAll(initialTags);
    }
}

