/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.rules.RuleQuery;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleDto;
import org.sonar.db.rule.RuleParamDto;
import org.sonar.markdown.Markdown;

public class CachingRuleFinder
implements RuleFinder {
    private static final Ordering<Map.Entry<RuleDefinitionDto, Rule>> FIND_BY_QUERY_ORDER = Ordering.natural().reverse().onResultOf(entry -> Long.valueOf(((RuleDefinitionDto)entry.getKey()).getUpdatedAt()));
    private final Map<RuleDefinitionDto, Rule> rulesByRuleDefinition;
    private final Map<Integer, Rule> rulesById;
    private final Map<RuleKey, Rule> rulesByKey;

    public CachingRuleFinder(DbClient dbClient) {
        try (DbSession dbSession = dbClient.openSession(false);){
            this.rulesByRuleDefinition = CachingRuleFinder.buildRulesByRuleDefinitionDto(dbClient, dbSession);
            this.rulesById = (Map)this.rulesByRuleDefinition.entrySet().stream().collect(MoreCollectors.uniqueIndex(entry -> ((RuleDefinitionDto)entry.getKey()).getId(), Map.Entry::getValue));
            this.rulesByKey = (Map)this.rulesByRuleDefinition.entrySet().stream().collect(MoreCollectors.uniqueIndex(entry -> ((RuleDefinitionDto)entry.getKey()).getKey(), Map.Entry::getValue));
        }
    }

    private static Map<RuleDefinitionDto, Rule> buildRulesByRuleDefinitionDto(DbClient dbClient, DbSession dbSession) {
        List dtos = dbClient.ruleDao().selectAllDefinitions(dbSession);
        Set ruleKeys = (Set)dtos.stream().map(RuleDefinitionDto::getKey).collect(MoreCollectors.toSet((int)dtos.size()));
        ImmutableListMultimap<Integer, RuleParamDto> ruleParamsByRuleId = CachingRuleFinder.retrieveRuleParameters(dbClient, dbSession, ruleKeys);
        HashMap<RuleDefinitionDto, Rule> rulesByDefinition = new HashMap<RuleDefinitionDto, Rule>(dtos.size());
        for (RuleDefinitionDto definition : dtos) {
            rulesByDefinition.put(definition, CachingRuleFinder.toRule(definition, ruleParamsByRuleId.get((Object)definition.getId())));
        }
        return ImmutableMap.copyOf(rulesByDefinition);
    }

    private static ImmutableListMultimap<Integer, RuleParamDto> retrieveRuleParameters(DbClient dbClient, DbSession dbSession, Set<RuleKey> ruleKeys) {
        if (ruleKeys.isEmpty()) {
            return ImmutableListMultimap.of();
        }
        return (ImmutableListMultimap)dbClient.ruleDao().selectRuleParamsByRuleKeys(dbSession, ruleKeys).stream().collect(MoreCollectors.index(RuleParamDto::getRuleId));
    }

    @Deprecated
    @CheckForNull
    public Rule findById(int ruleId) {
        return this.rulesById.get(ruleId);
    }

    @CheckForNull
    public Rule findByKey(@Nullable String repositoryKey, @Nullable String key) {
        if (repositoryKey == null || key == null) {
            return null;
        }
        return this.findByKey(RuleKey.of((String)repositoryKey, (String)key));
    }

    @CheckForNull
    public Rule findByKey(RuleKey key) {
        return this.rulesByKey.get(key);
    }

    @CheckForNull
    public Rule find(@Nullable RuleQuery query) {
        if (query == null) {
            return null;
        }
        return this.rulesByRuleDefinition.entrySet().stream().filter(entry -> CachingRuleFinder.matchQuery((RuleDefinitionDto)entry.getKey(), query)).sorted((Comparator<Map.Entry>)FIND_BY_QUERY_ORDER).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public Collection<Rule> findAll(@Nullable RuleQuery query) {
        if (query == null) {
            return Collections.emptyList();
        }
        return (Collection)this.rulesByRuleDefinition.entrySet().stream().filter(entry -> CachingRuleFinder.matchQuery((RuleDefinitionDto)entry.getKey(), query)).sorted((Comparator<Map.Entry>)FIND_BY_QUERY_ORDER).map(Map.Entry::getValue).collect(MoreCollectors.toList());
    }

    private static boolean matchQuery(RuleDefinitionDto ruleDefinition, RuleQuery ruleQuery) {
        if (RuleStatus.REMOVED.equals((Object)ruleDefinition.getStatus())) {
            return false;
        }
        String repositoryKey = ruleQuery.getRepositoryKey();
        if (ruleQuery.getRepositoryKey() != null && !repositoryKey.equals(ruleDefinition.getRepositoryKey())) {
            return false;
        }
        String key = ruleQuery.getKey();
        if (key != null && !key.equals(ruleDefinition.getRuleKey())) {
            return false;
        }
        String configKey = ruleQuery.getConfigKey();
        return configKey == null || configKey.equals(ruleDefinition.getConfigKey());
    }

    private static Rule toRule(RuleDefinitionDto ruleDefinition, List<RuleParamDto> params) {
        String severity = ruleDefinition.getSeverityString();
        String description = ruleDefinition.getDescription();
        RuleDto.Format descriptionFormat = ruleDefinition.getDescriptionFormat();
        Rule apiRule = new Rule();
        String[] systemTags = ruleDefinition.getSystemTags().toArray(new String[ruleDefinition.getSystemTags().size()]);
        apiRule.setName(ruleDefinition.getName()).setLanguage(ruleDefinition.getLanguage()).setKey(ruleDefinition.getRuleKey()).setConfigKey(ruleDefinition.getConfigKey()).setIsTemplate(ruleDefinition.isTemplate()).setCreatedAt(new Date(ruleDefinition.getCreatedAt())).setUpdatedAt(new Date(ruleDefinition.getUpdatedAt())).setRepositoryKey(ruleDefinition.getRepositoryKey()).setSeverity(severity != null ? RulePriority.valueOf((String)severity) : null).setStatus(ruleDefinition.getStatus().name()).setSystemTags(systemTags).setTags(systemTags).setId(ruleDefinition.getId());
        if (description != null && descriptionFormat != null) {
            if (RuleDto.Format.HTML.equals((Object)descriptionFormat)) {
                apiRule.setDescription(description);
            } else {
                apiRule.setDescription(Markdown.convertToHtml((String)description));
            }
        }
        ArrayList apiParams = Lists.newArrayList();
        for (RuleParamDto param : params) {
            apiParams.add(new RuleParam(apiRule, param.getName(), param.getDescription(), param.getType()).setDefaultValue(param.getDefaultValue()));
        }
        apiRule.setParams((List)apiParams);
        return apiRule;
    }
}

