/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.qualityprofile.ws.QProfileReference;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class RenameAction
implements QProfileWsAction {
    private static final int MAXIMUM_NAME_LENGTH = 100;
    private final DbClient dbClient;
    private final UserSession userSession;
    private final QProfileWsSupport wsSupport;

    public RenameAction(DbClient dbClient, UserSession userSession, QProfileWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction setDefault = controller.createAction("rename").setSince("5.2").setDescription("Rename a quality profile.<br> Requires one of the following permissions:<ul>  <li>'Administer Quality Profiles'</li>  <li>Edit right on the specified quality profile</li></ul>").setPost(true).setHandler((RequestHandler)this);
        setDefault.createParam("key").setDescription("Quality profile key").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy").setRequired(true);
        setDefault.createParam("name").setDescription("New quality profile name").setExampleValue((Object)"My Sonar way").setRequired(true);
    }

    public void handle(Request request, Response response) throws Exception {
        String newName = request.mandatoryParam("name");
        String profileKey = request.mandatoryParam("key");
        this.doHandle(newName, profileKey);
        response.noContent();
    }

    private void doHandle(String newName, String profileKey) {
        WsUtils.checkRequest(StringUtils.isNotBlank((String)newName), "Name must be set", new Object[0]);
        WsUtils.checkRequest(newName.length() <= 100, "Name is too long (>%d characters)", 100);
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QProfileDto qualityProfile = this.wsSupport.getProfile(dbSession, QProfileReference.fromKey(profileKey));
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, qualityProfile);
            this.wsSupport.checkCanEdit(dbSession, organization, qualityProfile);
            if (newName.equals(qualityProfile.getName())) {
                return;
            }
            String language = qualityProfile.getLanguage();
            Optional.ofNullable(this.dbClient.qualityProfileDao().selectByNameAndLanguage(dbSession, organization, newName, language)).ifPresent(found -> {
                throw BadRequestException.create(String.format("Quality profile already exists: %s", newName));
            });
            qualityProfile.setName(newName);
            this.dbClient.qualityProfileDao().update(dbSession, qualityProfile, new QProfileDto[0]);
            dbSession.commit();
        }
    }
}

