/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.qualityprofile.QProfileFactory;
import org.sonar.server.qualityprofile.ws.QProfileReference;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;
import org.sonar.server.user.UserSession;

public class DeleteAction
implements QProfileWsAction {
    private final Languages languages;
    private final QProfileFactory profileFactory;
    private final DbClient dbClient;
    private final UserSession userSession;
    private final QProfileWsSupport wsSupport;

    public DeleteAction(Languages languages, QProfileFactory profileFactory, DbClient dbClient, UserSession userSession, QProfileWsSupport wsSupport) {
        this.languages = languages;
        this.profileFactory = profileFactory;
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("delete").setDescription("Delete a quality profile and all its descendants. The default quality profile cannot be deleted.<br> Requires one of the following permissions:<ul>  <li>'Administer Quality Profiles'</li>  <li>Edit right on the specified quality profile</li></ul>").setSince("5.2").setPost(true).setHandler((RequestHandler)this);
        QProfileReference.defineParams(action, this.languages);
        QProfileWsSupport.createOrganizationParam(action).setSince("6.4");
    }

    public void handle(Request request, Response response) {
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QProfileDto profile = this.wsSupport.getProfile(dbSession, QProfileReference.from(request));
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, profile);
            this.wsSupport.checkCanEdit(dbSession, organization, profile);
            List<QProfileDto> descendants = this.selectDescendants(dbSession, profile);
            this.ensureNoneIsMarkedAsDefault(dbSession, profile, descendants);
            this.profileFactory.delete(dbSession, DeleteAction.merge(profile, descendants));
            dbSession.commit();
        }
        response.noContent();
    }

    private List<QProfileDto> selectDescendants(DbSession dbSession, QProfileDto profile) {
        return this.dbClient.qualityProfileDao().selectDescendants(dbSession, profile);
    }

    private void ensureNoneIsMarkedAsDefault(DbSession dbSession, QProfileDto profile, List<QProfileDto> descendants) {
        HashSet<String> allUuids = new HashSet<String>();
        allUuids.add(profile.getKee());
        descendants.forEach(p -> allUuids.add(p.getKee()));
        Set uuidsOfDefaultProfiles = this.dbClient.defaultQProfileDao().selectExistingQProfileUuids(dbSession, profile.getOrganizationUuid(), allUuids);
        Preconditions.checkArgument((!uuidsOfDefaultProfiles.contains(profile.getKee()) ? 1 : 0) != 0, (String)"Profile '%s' cannot be deleted because it is marked as default", (Object[])new Object[]{profile.getName()});
        descendants.stream().filter(p -> uuidsOfDefaultProfiles.contains(p.getKee())).findFirst().ifPresent(p -> {
            throw new IllegalArgumentException(String.format("Profile '%s' cannot be deleted because its descendant named '%s' is marked as default", profile.getName(), p.getName()));
        });
    }

    private static List<QProfileDto> merge(QProfileDto profile, List<QProfileDto> descendants) {
        return (List)Stream.concat(Stream.of(profile), descendants.stream()).collect(MoreCollectors.toList((int)(descendants.size() + 1)));
    }
}

