/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import java.util.Collection;
import java.util.Map;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.Severity;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.qualityprofile.RuleActivation;
import org.sonar.server.qualityprofile.RuleActivator;
import org.sonar.server.qualityprofile.ws.QProfileReference;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;
import org.sonar.server.user.UserSession;

public class ActivateRuleAction
implements QProfileWsAction {
    private final DbClient dbClient;
    private final RuleActivator ruleActivator;
    private final UserSession userSession;
    private final QProfileWsSupport wsSupport;

    public ActivateRuleAction(DbClient dbClient, RuleActivator ruleActivator, UserSession userSession, QProfileWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.ruleActivator = ruleActivator;
        this.userSession = userSession;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction activate = controller.createAction("activate_rule").setDescription("Activate a rule on a Quality Profile.<br> Requires one of the following permissions:<ul>  <li>'Administer Quality Profiles'</li>  <li>Edit right on the specified quality profile</li></ul>").setHandler((RequestHandler)this).setPost(true).setSince("4.4");
        activate.createParam("key").setDescription("Quality Profile key. Can be obtained through <code>api/qualityprofiles/search</code>").setDeprecatedKey("profile_key", "6.5").setRequired(true).setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        activate.createParam("rule").setDescription("Rule key").setDeprecatedKey("rule_key", "6.5").setRequired(true).setExampleValue((Object)"squid:AvoidCycles");
        activate.createParam("severity").setDescription(String.format("Severity. Ignored if parameter %s is true.", "reset")).setPossibleValues((Collection)Severity.ALL);
        activate.createParam("params").setDescription(String.format("Parameters as semi-colon list of <code>key=value</code>. Ignored if parameter %s is true.", "reset")).setExampleValue((Object)"params=key1=v1;key2=v2");
        activate.createParam("reset").setDescription("Reset severity and parameters of activated rule. Set the values defined on parent profile or from rule default values.").setBooleanPossibleValues();
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String profileKey = request.mandatoryParam("key");
            QProfileDto profile = this.wsSupport.getProfile(dbSession, QProfileReference.fromKey(profileKey));
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, profile);
            this.wsSupport.checkCanEdit(dbSession, organization, profile);
            RuleActivation activation = ActivateRuleAction.readActivation(request);
            this.ruleActivator.activateAndCommit(dbSession, activation, profile);
        }
        response.noContent();
    }

    private static RuleActivation readActivation(Request request) {
        RuleKey ruleKey = RuleKey.parse((String)request.mandatoryParam("rule"));
        boolean reset = Boolean.TRUE.equals(request.paramAsBoolean("reset"));
        if (reset) {
            return RuleActivation.createReset(ruleKey);
        }
        String severity = request.param("severity");
        Map params = null;
        String paramsAsString = request.param("params");
        if (paramsAsString != null) {
            params = KeyValueFormat.parse((String)paramsAsString);
        }
        return RuleActivation.create(ruleKey, severity, params);
    }
}

