/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.Severity;

@Immutable
public class RuleActivation {
    private final RuleKey ruleKey;
    private final boolean reset;
    private final String severity;
    private final Map<String, String> parameters = new HashMap<String, String>();

    private RuleActivation(RuleKey ruleKey, boolean reset, @Nullable String severity, @Nullable Map<String, String> parameters) {
        this.ruleKey = ruleKey;
        this.reset = reset;
        this.severity = severity;
        if (severity != null && !Severity.ALL.contains(severity)) {
            throw new IllegalArgumentException("Unknown severity: " + severity);
        }
        if (parameters != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                this.parameters.put(entry.getKey(), Strings.emptyToNull((String)entry.getValue()));
            }
        }
    }

    public static RuleActivation createReset(RuleKey ruleKey) {
        return new RuleActivation(ruleKey, true, null, null);
    }

    public static RuleActivation create(RuleKey ruleKey, @Nullable String severity, @Nullable Map<String, String> parameters) {
        return new RuleActivation(ruleKey, false, severity, parameters);
    }

    public static RuleActivation create(RuleKey ruleKey) {
        return RuleActivation.create(ruleKey, null, null);
    }

    @CheckForNull
    public String getSeverity() {
        return this.severity;
    }

    public RuleKey getRuleKey() {
        return this.ruleKey;
    }

    @CheckForNull
    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public boolean hasParameter(String key) {
        return this.parameters.containsKey(key);
    }

    public boolean isReset() {
        return this.reset;
    }
}

