/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.text.XmlWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.ActiveRuleParamDto;
import org.sonar.db.qualityprofile.OrgActiveRuleDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.qualityprofile.BulkChangeResult;
import org.sonar.server.qualityprofile.QProfileBackuper;
import org.sonar.server.qualityprofile.QProfileFactory;
import org.sonar.server.qualityprofile.QProfileName;
import org.sonar.server.qualityprofile.QProfileReset;
import org.sonar.server.qualityprofile.QProfileRestoreSummary;
import org.sonar.server.qualityprofile.RuleActivation;

@ServerSide
public class QProfileBackuperImpl
implements QProfileBackuper {
    private static final Joiner RULE_KEY_JOINER = Joiner.on((String)", ").skipNulls();
    private static final String ATTRIBUTE_PROFILE = "profile";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_LANGUAGE = "language";
    private static final String ATTRIBUTE_RULES = "rules";
    private static final String ATTRIBUTE_RULE = "rule";
    private static final String ATTRIBUTE_REPOSITORY_KEY = "repositoryKey";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ATTRIBUTE_PRIORITY = "priority";
    private static final String ATTRIBUTE_PARAMETERS = "parameters";
    private static final String ATTRIBUTE_PARAMETER = "parameter";
    private static final String ATTRIBUTE_PARAMETER_KEY = "key";
    private static final String ATTRIBUTE_PARAMETER_VALUE = "value";
    private final DbClient db;
    private final QProfileReset profileReset;
    private final QProfileFactory profileFactory;

    public QProfileBackuperImpl(DbClient db, QProfileReset profileReset, QProfileFactory profileFactory) {
        this.db = db;
        this.profileReset = profileReset;
        this.profileFactory = profileFactory;
    }

    @Override
    public void backup(DbSession dbSession, QProfileDto profile, Writer writer) {
        List activeRules = this.db.activeRuleDao().selectByProfile(dbSession, profile);
        activeRules.sort(BackupActiveRuleComparator.INSTANCE);
        this.writeXml(dbSession, writer, profile, activeRules.iterator());
    }

    private void writeXml(DbSession dbSession, Writer writer, QProfileDto profile, Iterator<OrgActiveRuleDto> activeRules) {
        XmlWriter xml = XmlWriter.of((Writer)writer).declaration();
        xml.begin(ATTRIBUTE_PROFILE);
        xml.prop(ATTRIBUTE_NAME, profile.getName());
        xml.prop(ATTRIBUTE_LANGUAGE, profile.getLanguage());
        xml.begin(ATTRIBUTE_RULES);
        while (activeRules.hasNext()) {
            ActiveRuleDto activeRule = (ActiveRuleDto)activeRules.next();
            xml.begin(ATTRIBUTE_RULE);
            xml.prop(ATTRIBUTE_REPOSITORY_KEY, activeRule.getRuleKey().repository());
            xml.prop("key", activeRule.getRuleKey().rule());
            xml.prop(ATTRIBUTE_PRIORITY, activeRule.getSeverityString());
            xml.begin(ATTRIBUTE_PARAMETERS);
            for (ActiveRuleParamDto param : this.db.activeRuleDao().selectParamsByActiveRuleId(dbSession, activeRule.getId())) {
                xml.begin(ATTRIBUTE_PARAMETER).prop("key", param.getKey()).prop(ATTRIBUTE_PARAMETER_VALUE, param.getValue()).end();
            }
            xml.end(ATTRIBUTE_PARAMETERS);
            xml.end(ATTRIBUTE_RULE);
        }
        xml.end(ATTRIBUTE_RULES).end(ATTRIBUTE_PROFILE).close();
    }

    @Override
    public QProfileRestoreSummary restore(DbSession dbSession, Reader backup, OrganizationDto organization, @Nullable String overriddenProfileName) {
        return this.restore(dbSession, backup, (QProfileName nameInBackup) -> {
            QProfileName targetName = nameInBackup;
            if (overriddenProfileName != null) {
                targetName = new QProfileName(nameInBackup.getLanguage(), overriddenProfileName);
            }
            return this.profileFactory.getOrCreateCustom(dbSession, organization, targetName);
        });
    }

    @Override
    public QProfileRestoreSummary restore(DbSession dbSession, Reader backup, QProfileDto profile) {
        return this.restore(dbSession, backup, (QProfileName nameInBackup) -> {
            Preconditions.checkArgument((boolean)profile.getLanguage().equals(nameInBackup.getLanguage()), (String)"Can't restore %s backup on %s profile with key [%s]. Languages are different.", (Object[])new Object[]{nameInBackup.getLanguage(), profile.getLanguage(), profile.getKee()});
            return profile;
        });
    }

    private QProfileRestoreSummary restore(DbSession dbSession, Reader backup, Function<QProfileName, QProfileDto> profileLoader) {
        try {
            String profileLang = null;
            String profileName = null;
            List<Object> ruleActivations = Lists.newArrayList();
            SMInputFactory inputFactory = QProfileBackuperImpl.initStax();
            SMHierarchicCursor rootC = inputFactory.rootElementCursor(backup);
            rootC.advance();
            if (!ATTRIBUTE_PROFILE.equals(rootC.getLocalName())) {
                throw new IllegalArgumentException("Backup XML is not valid. Root element must be <profile>.");
            }
            SMInputCursor cursor = rootC.childElementCursor();
            while (cursor.getNext() != null) {
                String nodeName = cursor.getLocalName();
                if (StringUtils.equals((String)ATTRIBUTE_NAME, (String)nodeName)) {
                    profileName = StringUtils.trim((String)cursor.collectDescendantText(false));
                    continue;
                }
                if (StringUtils.equals((String)ATTRIBUTE_LANGUAGE, (String)nodeName)) {
                    profileLang = StringUtils.trim((String)cursor.collectDescendantText(false));
                    continue;
                }
                if (!StringUtils.equals((String)ATTRIBUTE_RULES, (String)nodeName)) continue;
                SMInputCursor rulesCursor = cursor.childElementCursor(ATTRIBUTE_RULE);
                ruleActivations = QProfileBackuperImpl.parseRuleActivations(rulesCursor);
            }
            QProfileName targetName = new QProfileName(profileLang, profileName);
            QProfileDto targetProfile = profileLoader.apply(targetName);
            BulkChangeResult changes = this.profileReset.reset(dbSession, targetProfile, ruleActivations);
            return new QProfileRestoreSummary(targetProfile, changes);
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Fail to restore Quality profile backup", e);
        }
    }

    private static List<RuleActivation> parseRuleActivations(SMInputCursor rulesCursor) throws XMLStreamException {
        ArrayList<RuleActivation> activations = new ArrayList<RuleActivation>();
        HashSet<RuleKey> activatedKeys = new HashSet<RuleKey>();
        ArrayList<RuleKey> duplicatedKeys = new ArrayList<RuleKey>();
        while (rulesCursor.getNext() != null) {
            SMInputCursor ruleCursor = rulesCursor.childElementCursor();
            String repositoryKey = null;
            String key = null;
            String severity = null;
            HashMap<String, String> parameters = new HashMap<String, String>();
            while (ruleCursor.getNext() != null) {
                String nodeName = ruleCursor.getLocalName();
                if (StringUtils.equals((String)ATTRIBUTE_REPOSITORY_KEY, (String)nodeName)) {
                    repositoryKey = StringUtils.trim((String)ruleCursor.collectDescendantText(false));
                    continue;
                }
                if (StringUtils.equals((String)"key", (String)nodeName)) {
                    key = StringUtils.trim((String)ruleCursor.collectDescendantText(false));
                    continue;
                }
                if (StringUtils.equals((String)ATTRIBUTE_PRIORITY, (String)nodeName)) {
                    severity = StringUtils.trim((String)ruleCursor.collectDescendantText(false));
                    continue;
                }
                if (!StringUtils.equals((String)ATTRIBUTE_PARAMETERS, (String)nodeName)) continue;
                SMInputCursor propsCursor = ruleCursor.childElementCursor(ATTRIBUTE_PARAMETER);
                QProfileBackuperImpl.readParameters(propsCursor, parameters);
            }
            RuleKey ruleKey = RuleKey.of(repositoryKey, key);
            if (activatedKeys.contains(ruleKey)) {
                duplicatedKeys.add(ruleKey);
            }
            activatedKeys.add(ruleKey);
            activations.add(RuleActivation.create(ruleKey, severity, parameters));
        }
        if (!duplicatedKeys.isEmpty()) {
            throw new IllegalArgumentException("The quality profile cannot be restored as it contains duplicates for the following rules: " + RULE_KEY_JOINER.join(duplicatedKeys));
        }
        return activations;
    }

    private static void readParameters(SMInputCursor propsCursor, Map<String, String> parameters) throws XMLStreamException {
        while (propsCursor.getNext() != null) {
            SMInputCursor propCursor = propsCursor.childElementCursor();
            String key = null;
            String value = null;
            while (propCursor.getNext() != null) {
                String nodeName = propCursor.getLocalName();
                if (StringUtils.equals((String)"key", (String)nodeName)) {
                    key = StringUtils.trim((String)propCursor.collectDescendantText(false));
                    continue;
                }
                if (!StringUtils.equals((String)ATTRIBUTE_PARAMETER_VALUE, (String)nodeName)) continue;
                value = StringUtils.trim((String)propCursor.collectDescendantText(false));
            }
            if (key == null) continue;
            parameters.put(key, value);
        }
    }

    private static SMInputFactory initStax() {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        return new SMInputFactory(xmlFactory);
    }

    private static enum BackupActiveRuleComparator implements Comparator<ActiveRuleDto>
    {
        INSTANCE;


        @Override
        public int compare(ActiveRuleDto o1, ActiveRuleDto o2) {
            return new CompareToBuilder().append((Object)o1.getRuleKey().repository(), (Object)o2.getRuleKey().repository()).append((Object)o1.getRuleKey().rule(), (Object)o2.getRuleKey().rule()).toComparison();
        }
    }
}

