/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.io.Resources;
import java.util.Collection;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.qualitygate.QualityGateConditionDto;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.qualitygate.QualityGates;
import org.sonar.server.qualitygate.ws.QualityGatesWs;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.ws.WsUtils;

public class ShowAction
implements QualityGatesWsAction {
    private final QualityGates qualityGates;

    public ShowAction(QualityGates qualityGates) {
        this.qualityGates = qualityGates;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("show").setDescription("Display the details of a quality gate").setSince("4.3").setResponseExample(Resources.getResource(this.getClass(), (String)"example-show.json")).setHandler((RequestHandler)this);
        action.createParam("id").setDescription("ID of the quality gate. Either id or name must be set").setExampleValue((Object)"1");
        action.createParam("name").setDescription("Name of the quality gate. Either id or name must be set").setExampleValue((Object)"My Quality Gate");
    }

    public void handle(Request request, Response response) {
        Long qGateId = request.paramAsLong("id");
        String qGateName = request.param("name");
        ShowAction.checkOneOfIdOrNamePresent(qGateId, qGateName);
        QualityGateDto qGate = qGateId == null ? this.qualityGates.get(qGateName) : this.qualityGates.get(qGateId);
        qGateId = qGate.getId();
        try (JsonWriter writer = response.newJsonWriter();){
            writer.beginObject().prop("id", (Number)qGate.getId()).prop("name", qGate.getName());
            Collection<QualityGateConditionDto> conditions = this.qualityGates.listConditions(qGateId);
            if (!conditions.isEmpty()) {
                writer.name("conditions").beginArray();
                for (QualityGateConditionDto condition : conditions) {
                    QualityGatesWs.writeQualityGateCondition(condition, writer);
                }
                writer.endArray();
            }
            writer.endObject().close();
        }
    }

    private static void checkOneOfIdOrNamePresent(@Nullable Long qGateId, @Nullable String qGateName) {
        WsUtils.checkRequest(qGateId == null ^ qGateName == null, "Either '%s' or '%s' must be provided", "id", "name");
    }
}

