/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.protobuf.Message;
import java.util.Collection;
import java.util.stream.Collectors;
import org.sonar.api.measures.Metric;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.qualitygate.ValidRatingMetrics;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsQualityGates;

public class AppAction
implements QualityGatesWsAction {
    private final UserSession userSession;
    private final DbClient dbClient;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public AppAction(UserSession userSession, DbClient dbClient, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    public void define(WebService.NewController controller) {
        controller.createAction("app").setInternal(true).setDescription("Get initialization items for the admin UI. For internal use").setResponseExample(this.getClass().getResource("app-example.json")).setSince("4.3").setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) {
        WsUtils.writeProtobuf((Message)WsQualityGates.AppWsResponse.newBuilder().setEdit(this.userSession.hasPermission(OrganizationPermission.ADMINISTER_QUALITY_GATES, this.defaultOrganizationProvider.get().getUuid())).addAllMetrics((Iterable)this.loadMetrics().stream().map(AppAction::toMetric).collect(Collectors.toList())).build(), request, response);
    }

    private static WsQualityGates.AppWsResponse.Metric toMetric(MetricDto metricDto) {
        String domain = metricDto.getDomain();
        WsQualityGates.AppWsResponse.Metric.Builder metricBuilder = WsQualityGates.AppWsResponse.Metric.newBuilder().setKey(metricDto.getKey()).setName(metricDto.getShortName()).setType(metricDto.getValueType()).setHidden(metricDto.isHidden());
        if (domain != null) {
            metricBuilder.setDomain(domain);
        }
        return metricBuilder.build();
    }

    private Collection<MetricDto> loadMetrics() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Collection collection = this.dbClient.metricDao().selectEnabled(dbSession).stream().filter(metric -> !metric.isDataType() && !"alert_status".equals(metric.getKey()) && (!Metric.ValueType.RATING.name().equals(metric.getValueType()) || ValidRatingMetrics.isCoreRatingMetric(metric.getKey()))).collect(Collectors.toList());
            return collection;
        }
    }
}

