/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectanalysis.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.util.Protobuf;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.component.SnapshotQuery;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.projectanalysis.ws.ProjectAnalysesWsAction;
import org.sonar.server.projectanalysis.ws.SearchData;
import org.sonar.server.projectanalysis.ws.SearchResponseBuilder;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.ProjectAnalyses;
import org.sonarqube.ws.client.projectanalysis.EventCategory;
import org.sonarqube.ws.client.projectanalysis.SearchRequest;

public class SearchAction
implements ProjectAnalysesWsAction {
    private static final Set<String> ALLOWED_QUALIFIERS = ImmutableSet.of((Object)"TRK", (Object)"APP", (Object)"VW");
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final UserSession userSession;

    public SearchAction(DbClient dbClient, ComponentFinder componentFinder, UserSession userSession) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search").setDescription("Search a project analyses and attached events.<br>Requires the following permission: 'Browse' on the specified project").setSince("6.3").setResponseExample(this.getClass().getResource("search-example.json")).setHandler((RequestHandler)this);
        action.addPagingParams(100, 500);
        action.createParam("project").setDescription("Project key").setRequired(true).setExampleValue((Object)"my_project");
        action.createParam("branch").setDescription("Branch key").setSince("6.6").setInternal(true).setExampleValue((Object)"feature/my_branch");
        action.createParam("category").setDescription("Event category. Filter analyses that have at least one event of the category specified.").setPossibleValues(EnumSet.allOf(EventCategory.class)).setExampleValue((Object)EventCategory.OTHER.name());
        action.createParam("from").setDescription("Filter analyses created after the given date (inclusive). <br>Either a date (server timezone) or datetime can be provided").setExampleValue((Object)"2013-05-01").setSince("6.5");
        action.createParam("to").setDescription("Filter analyses created before the given date (inclusive). <br>Either a date (server timezone) or datetime can be provided").setExampleValue((Object)"2017-10-19 or 2017-10-19T13:00:00+0200").setSince("6.5");
    }

    public void handle(Request request, Response response) throws Exception {
        SearchData searchData = this.load(SearchAction.toWsRequest(request));
        ProjectAnalyses.SearchResponse searchResponse = new SearchResponseBuilder(searchData).build();
        WsUtils.writeProtobuf((Message)searchResponse, request, response);
    }

    private static SearchRequest toWsRequest(Request request) {
        String category = request.param("category");
        return SearchRequest.builder().setProject(request.mandatoryParam("project")).setBranch(request.param("branch")).setCategory(category == null ? null : EventCategory.valueOf((String)category)).setPage(request.mandatoryParamAsInt("p")).setPageSize(request.mandatoryParamAsInt("ps")).setFrom(request.param("from")).setTo(request.param("to")).build();
    }

    private SearchData load(SearchRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            SearchData.Builder searchResults = SearchData.builder(dbSession, request);
            this.addProject(searchResults);
            this.checkPermission(searchResults.getProject());
            this.addAnalyses(searchResults);
            this.addEvents(searchResults);
            SearchData searchData = searchResults.build();
            return searchData;
        }
    }

    private void addAnalyses(SearchData.Builder data) {
        SnapshotQuery dbQuery = new SnapshotQuery().setComponentUuid(data.getProject().uuid()).setStatus("P").setSort(SnapshotQuery.SORT_FIELD.BY_DATE, SnapshotQuery.SORT_ORDER.DESC);
        Protobuf.setNullable((Object)data.getRequest().getFrom(), from -> dbQuery.setCreatedAfter(Long.valueOf(DateUtils.parseStartingDateOrDateTime((String)from).getTime())));
        Protobuf.setNullable((Object)data.getRequest().getTo(), to -> dbQuery.setCreatedBefore(Long.valueOf(DateUtils.parseEndingDateOrDateTime((String)to).getTime() + 1000L)));
        data.setAnalyses(this.dbClient.snapshotDao().selectAnalysesByQuery(data.getDbSession(), dbQuery));
    }

    private void addEvents(SearchData.Builder data) {
        List analyses = (List)data.getAnalyses().stream().map(SnapshotDto::getUuid).collect(MoreCollectors.toList());
        data.setEvents(this.dbClient.eventDao().selectByAnalysisUuids(data.getDbSession(), analyses));
    }

    private void checkPermission(ComponentDto project) {
        this.userSession.checkComponentPermission("user", project);
    }

    private void addProject(SearchData.Builder data) {
        ComponentDto project = this.loadComponent(data.getDbSession(), data.getRequest());
        Preconditions.checkArgument(("PRJ".equals(project.scope()) && ALLOWED_QUALIFIERS.contains(project.qualifier()) ? 1 : 0) != 0, (Object)"A project, portfolio or application is required");
        data.setProject(project);
    }

    private ComponentDto loadComponent(DbSession dbSession, SearchRequest request) {
        String project = request.getProject();
        String branch = request.getBranch();
        if (branch != null) {
            return this.componentFinder.getByKeyAndBranch(dbSession, project, branch);
        }
        return this.componentFinder.getByKey(dbSession, project);
    }
}

