/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.permission.ProjectPermissions;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchMapper;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentMapper;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.GroupPermissionDto;
import org.sonar.db.permission.UserPermissionDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.es.ProjectIndexer;
import org.sonar.server.es.ProjectIndexers;
import org.sonar.server.project.Visibility;
import org.sonar.server.project.ws.ProjectsWsAction;
import org.sonar.server.project.ws.ProjectsWsSupport;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class UpdateVisibilityAction
implements ProjectsWsAction {
    private static final Set<String> AUTHORIZED_QUALIFIERS = ImmutableSet.of((Object)"TRK", (Object)"VW", (Object)"APP");
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final UserSession userSession;
    private final ProjectIndexers projectIndexers;
    private final ProjectsWsSupport projectsWsSupport;

    public UpdateVisibilityAction(DbClient dbClient, ComponentFinder componentFinder, UserSession userSession, ProjectIndexers projectIndexers, ProjectsWsSupport projectsWsSupport) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
        this.projectIndexers = projectIndexers;
        this.projectsWsSupport = projectsWsSupport;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("update_visibility").setDescription("Updates visibility of a project.<br>Requires 'Project administer' permission on the specified project").setSince("6.4").setPost(true).setHandler((RequestHandler)this);
        action.createParam("project").setDescription("Project key").setExampleValue((Object)"my_project").setRequired(true);
        action.createParam("visibility").setDescription("New visibility").setPossibleValues(Visibility.getLabels()).setRequired(true);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        String projectKey = request.mandatoryParam("project");
        boolean changeToPrivate = Visibility.isPrivate(request.mandatoryParam("visibility"));
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto component = this.componentFinder.getByKey(dbSession, projectKey);
            WsUtils.checkRequest(component.isRootProject() && AUTHORIZED_QUALIFIERS.contains(component.qualifier()), "Component must be a project, a portfolio or an application", new Object[0]);
            this.userSession.checkComponentPermission("admin", component);
            WsUtils.checkRequest(this.noPendingTask(dbSession, component), "Component visibility can't be changed as long as it has background task(s) pending or in progress", new Object[0]);
            if (changeToPrivate != component.isPrivate()) {
                OrganizationDto organization = (OrganizationDto)this.dbClient.organizationDao().selectByUuid(dbSession, component.getOrganizationUuid()).orElseThrow(() -> new IllegalStateException(String.format("Could not find organization with uuid '%s' of project '%s'", component.getOrganizationUuid(), projectKey)));
                this.projectsWsSupport.checkCanUpdateProjectsVisibility(organization, changeToPrivate);
                this.setPrivateForRootComponentUuid(dbSession, component.uuid(), changeToPrivate);
                if (changeToPrivate) {
                    this.updatePermissionsToPrivate(dbSession, component);
                } else {
                    this.updatePermissionsToPublic(dbSession, component);
                }
                this.projectIndexers.commitAndIndex(dbSession, Collections.singletonList(component), ProjectIndexer.Cause.PERMISSION_CHANGE);
            }
            response.noContent();
        }
    }

    private void setPrivateForRootComponentUuid(DbSession dbSession, String uuid, boolean isPrivate) {
        this.dbClient.componentDao().setPrivateForRootComponentUuid(dbSession, uuid, isPrivate);
        ComponentMapper mapper = (ComponentMapper)dbSession.getMapper(ComponentMapper.class);
        ((BranchMapper)dbSession.getMapper(BranchMapper.class)).selectByProjectUuid(uuid).stream().filter(branch -> !uuid.equals(branch.getUuid())).forEach(branch -> mapper.setPrivateForRootComponentUuid(branch.getUuid(), isPrivate));
    }

    private boolean noPendingTask(DbSession dbSession, ComponentDto rootComponent) {
        return this.dbClient.ceQueueDao().selectByComponentUuid(dbSession, rootComponent.uuid()).isEmpty();
    }

    private void updatePermissionsToPrivate(DbSession dbSession, ComponentDto component) {
        this.dbClient.groupPermissionDao().deleteByRootComponentIdAndGroupId(dbSession, component.getId().longValue(), null);
        ProjectPermissions.PUBLIC_PERMISSIONS.forEach(permission -> {
            this.dbClient.groupPermissionDao().selectGroupIdsWithPermissionOnProjectBut(dbSession, component.getId().longValue(), permission).forEach(groupId -> this.insertProjectPermissionOnGroup(dbSession, component, (String)permission, (Integer)groupId));
            this.dbClient.userPermissionDao().selectUserIdsWithPermissionOnProjectBut(dbSession, component.getId().longValue(), permission).forEach(userId -> this.insertProjectPermissionOnUser(dbSession, component, (String)permission, (Integer)userId));
        });
    }

    private void insertProjectPermissionOnUser(DbSession dbSession, ComponentDto component, String permission, Integer userId) {
        this.dbClient.userPermissionDao().insert(dbSession, new UserPermissionDto(component.getOrganizationUuid(), permission, userId.intValue(), component.getId()));
    }

    private void insertProjectPermissionOnGroup(DbSession dbSession, ComponentDto component, String permission, Integer groupId) {
        this.dbClient.groupPermissionDao().insert(dbSession, new GroupPermissionDto().setOrganizationUuid(component.getOrganizationUuid()).setResourceId(component.getId()).setGroupId(groupId).setRole(permission));
    }

    private void updatePermissionsToPublic(DbSession dbSession, ComponentDto component) {
        ProjectPermissions.PUBLIC_PERMISSIONS.forEach(permission -> {
            this.dbClient.groupPermissionDao().deleteByRootComponentIdAndPermission(dbSession, component.getId().longValue(), permission);
            this.dbClient.userPermissionDao().deleteProjectPermissionOfAnyUser(dbSession, component.getId().longValue(), permission);
        });
    }
}

