/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.component.ComponentService;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.project.ws.ProjectsWsAction;

public class UpdateKeyAction
implements ProjectsWsAction {
    private final DbClient dbClient;
    private final ComponentService componentService;

    public UpdateKeyAction(DbClient dbClient, ComponentService componentService) {
        this.dbClient = dbClient;
        this.componentService = componentService;
    }

    public void define(WebService.NewController context) {
        this.doDefine(context);
    }

    public WebService.NewAction doDefine(WebService.NewController context) {
        WebService.NewAction action = context.createAction("update_key").setDescription("Update a project or module key and all its sub-components keys.<br>Either '%s' or '%s' must be provided.<br> Requires one of the following permissions: <ul><li>'Administer System'</li><li>'Administer' rights on the specified project</li></ul>", new Object[]{"from", "projectId"}).setSince("6.1").setPost(true).setHandler((RequestHandler)this);
        action.setChangelog(new Change[]{new Change("6.4", "Move from api/components/update_key to api/projects/update_key"), new Change("7.1", "Ability to update key of a disabled module")});
        action.createParam("projectId").setDescription("Project or module id").setDeprecatedKey("id", "6.4").setDeprecatedSince("6.4").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("from").setDescription("Project or module key").setDeprecatedKey("key", "6.4").setExampleValue((Object)"my_old_project");
        action.createParam("to").setDescription("New component key").setRequired(true).setDeprecatedKey("newKey", "6.4").setExampleValue((Object)"my_new_project");
        return action;
    }

    public void handle(Request request, Response response) throws Exception {
        String uuid = request.param("projectId");
        String key = request.param("from");
        String newKey = request.mandatoryParam("to");
        Preconditions.checkArgument((boolean)(uuid != null ^ key != null), (String)"Either '%s' or '%s' must be provided", (Object[])new Object[]{"projectId", "from"});
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional component = uuid != null ? this.dbClient.componentDao().selectByUuid(dbSession, uuid) : this.dbClient.componentDao().selectByKey(dbSession, key);
            if (!component.isPresent() || ((ComponentDto)component.get()).getMainBranchProjectUuid() != null) {
                throw new NotFoundException("Component not found");
            }
            this.componentService.updateKey(dbSession, (ComponentDto)component.get(), newKey);
        }
        response.noContent();
    }
}

