/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentKeyUpdaterDao;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.component.ComponentService;
import org.sonar.server.project.ws.ProjectsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsProjects;
import org.sonarqube.ws.client.project.BulkUpdateKeyWsRequest;

public class BulkUpdateKeyAction
implements ProjectsWsAction {
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final ComponentKeyUpdaterDao componentKeyUpdater;
    private final ComponentService componentService;
    private final UserSession userSession;

    public BulkUpdateKeyAction(DbClient dbClient, ComponentFinder componentFinder, ComponentService componentService, UserSession userSession) {
        this.dbClient = dbClient;
        this.componentKeyUpdater = dbClient.componentKeyUpdaterDao();
        this.componentFinder = componentFinder;
        this.componentService = componentService;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        this.doDefine(context);
    }

    public WebService.NewAction doDefine(WebService.NewController context) {
        WebService.NewAction action = context.createAction("bulk_update_key").setDescription("Bulk update a project or module key and all its sub-components keys. The bulk update allows to replace a part of the current key by another string on the current project and all its sub-modules.<br>It's possible to simulate the bulk update by setting the parameter '%s' at true. No key is updated with a dry run.<br>Ex: to rename a project with key 'my_project' to 'my_new_project' and all its sub-components keys, call the WS with parameters:<ul>  <li>%s: my_project</li>  <li>%s: my_</li>  <li>%s: my_new_</li></ul>Either '%s' or '%s' must be provided.<br> Requires one of the following permissions: <ul><li>'Administer System'</li><li>'Administer' rights on the specified project</li></ul>", new Object[]{"dryRun", "project", "from", "to", "projectId", "project"}).setSince("6.1").setPost(true).setResponseExample(this.getClass().getResource("bulk_update_key-example.json")).setHandler((RequestHandler)this);
        action.setChangelog(new Change[]{new Change("6.4", "Moved from api/components/bulk_update_key to api/projects/bulk_update_key")});
        action.createParam("projectId").setDescription("Project or module ID").setDeprecatedKey("id", "6.4").setDeprecatedSince("6.4").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("project").setDescription("Project or module key").setDeprecatedKey("key", "6.4").setExampleValue((Object)"my_old_project");
        action.createParam("from").setDescription("String to match in components keys").setRequired(true).setExampleValue((Object)"_old");
        action.createParam("to").setDescription("String replacement in components keys").setRequired(true).setExampleValue((Object)"_new");
        action.createParam("dryRun").setDescription("Simulate bulk update. No component key is updated.").setBooleanPossibleValues().setDefaultValue((Object)false);
        return action;
    }

    public void handle(Request request, Response response) throws Exception {
        WsUtils.writeProtobuf((Message)this.doHandle(BulkUpdateKeyAction.toWsRequest(request)), request, response);
    }

    private WsProjects.BulkUpdateKeyWsResponse doHandle(BulkUpdateKeyWsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto projectOrModule = this.componentFinder.getByUuidOrKey(dbSession, request.getId(), request.getKey(), ComponentFinder.ParamNames.ID_AND_KEY);
            ComponentKeyUpdaterDao.checkIsProjectOrModule((ComponentDto)projectOrModule);
            this.userSession.checkComponentPermission("admin", projectOrModule);
            Map newKeysByOldKeys = this.componentKeyUpdater.simulateBulkUpdateKey(dbSession, projectOrModule.uuid(), request.getFrom(), request.getTo());
            Map newKeysWithDuplicateMap = this.componentKeyUpdater.checkComponentKeys(dbSession, (List)ImmutableList.copyOf(newKeysByOldKeys.values()));
            if (!request.isDryRun()) {
                BulkUpdateKeyAction.checkNoDuplicate(newKeysWithDuplicateMap);
                this.bulkUpdateKey(dbSession, request, projectOrModule);
            }
            WsProjects.BulkUpdateKeyWsResponse bulkUpdateKeyWsResponse = BulkUpdateKeyAction.buildResponse(newKeysByOldKeys, newKeysWithDuplicateMap);
            return bulkUpdateKeyWsResponse;
        }
    }

    private static void checkNoDuplicate(Map<String, Boolean> newKeysWithDuplicateMap) {
        newKeysWithDuplicateMap.entrySet().forEach(entry -> WsUtils.checkRequest((Boolean)entry.getValue() == false, "Impossible to update key: a component with key \"%s\" already exists.", entry.getKey()));
    }

    private void bulkUpdateKey(DbSession dbSession, BulkUpdateKeyWsRequest request, ComponentDto projectOrModule) {
        this.componentService.bulkUpdateKey(dbSession, projectOrModule, request.getFrom(), request.getTo());
    }

    private static WsProjects.BulkUpdateKeyWsResponse buildResponse(Map<String, String> newKeysByOldKeys, Map<String, Boolean> newKeysWithDuplicateMap) {
        WsProjects.BulkUpdateKeyWsResponse.Builder response = WsProjects.BulkUpdateKeyWsResponse.newBuilder();
        newKeysByOldKeys.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(entry -> {
            String newKey = (String)entry.getValue();
            response.addKeysBuilder().setKey((String)entry.getKey()).setNewKey(newKey).setDuplicate(newKeysWithDuplicateMap.getOrDefault(newKey, false).booleanValue());
        });
        return response.build();
    }

    private static BulkUpdateKeyWsRequest toWsRequest(Request request) {
        return BulkUpdateKeyWsRequest.builder().setId(request.param("projectId")).setKey(request.param("project")).setFrom(request.mandatoryParam("from")).setTo(request.mandatoryParam("to")).setDryRun(request.mandatoryParamAsBoolean("dryRun")).build();
    }
}

