/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentQuery;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.component.ComponentCleanerService;
import org.sonar.server.project.Visibility;
import org.sonar.server.project.ws.ProjectsWsAction;
import org.sonar.server.project.ws.ProjectsWsSupport;
import org.sonar.server.project.ws.SearchAction;
import org.sonar.server.user.UserSession;
import org.sonarqube.ws.client.project.SearchWsRequest;

public class BulkDeleteAction
implements ProjectsWsAction {
    private static final String ACTION = "bulk_delete";
    private final ComponentCleanerService componentCleanerService;
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ProjectsWsSupport support;

    public BulkDeleteAction(ComponentCleanerService componentCleanerService, DbClient dbClient, UserSession userSession, ProjectsWsSupport support) {
        this.componentCleanerService = componentCleanerService;
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.support = support;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setPost(true).setDescription("Delete one or several projects.<br />Requires 'Administer System' permission.").setSince("5.2").setHandler((RequestHandler)this).setChangelog(new Change[]{new Change("6.7.2", "Only the 1'000 first items in project filters are taken into account")});
        this.support.addOrganizationParam(action);
        action.createParam("projects").setDescription("Comma-separated list of project keys").setDeprecatedKey("keys", "6.4").setExampleValue((Object)String.join((CharSequence)",", "my_project", "another_project"));
        action.createParam("projectIds").setDescription("Comma-separated list of project ids. Only the 1'000 first ids are used. Others are silently ignored.").setDeprecatedKey("ids", "6.4").setDeprecatedSince("6.4").setExampleValue((Object)String.join((CharSequence)",", "AU-Tpxb--iU5OvuD2FLy", "AU-TpxcA-iU5OvuD2FLz"));
        action.createParam("q").setDescription("Limit to: <ul><li>component names that contain the supplied string</li><li>component keys that contain the supplied string</li></ul>").setExampleValue((Object)"sonar");
        action.createParam("qualifiers").setDescription("Comma-separated list of component qualifiers. Filter the results with the specified qualifiers").setPossibleValues(new Object[]{"TRK", "VW", "APP"}).setDefaultValue((Object)"TRK");
        action.createParam("visibility").setDescription("Filter the projects that should be visible to everyone (%s), or only specific user/groups (%s).<br/>If no visibility is specified, the default project visibility of the organization will be used.", new Object[]{Visibility.PUBLIC.getLabel(), Visibility.PRIVATE.getLabel()}).setRequired(false).setInternal(true).setSince("6.4").setPossibleValues(Visibility.getLabels());
        action.createParam("analyzedBefore").setDescription("Filter the projects for which last analysis is older than the given date (exclusive).<br> Either a date (server timezone) or datetime can be provided.").setSince("6.6").setExampleValue((Object)"2017-10-19 or 2017-10-19T13:00:00+0200");
        action.createParam("onProvisionedOnly").setDescription("Filter the projects that are provisioned").setBooleanPossibleValues().setDefaultValue((Object)"false").setSince("6.6");
    }

    public void handle(Request request, Response response) throws Exception {
        SearchWsRequest searchRequest = BulkDeleteAction.toSearchWsRequest(request);
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.support.getOrganization(dbSession, searchRequest.getOrganization());
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER, organization);
            ComponentQuery query = SearchAction.buildDbQuery(searchRequest);
            this.dbClient.componentDao().selectByQuery(dbSession, organization.getUuid(), query, 0, Integer.MAX_VALUE).forEach(p -> this.componentCleanerService.delete(dbSession, (ComponentDto)p));
        }
        response.noContent();
    }

    private static SearchWsRequest toSearchWsRequest(Request request) {
        return SearchWsRequest.builder().setOrganization(request.param("organization")).setQualifiers(request.mandatoryParamAsStrings("qualifiers")).setQuery(request.param("q")).setVisibility(request.param("visibility")).setAnalyzedBefore(request.param("analyzedBefore")).setOnProvisionedOnly(request.mandatoryParamAsBoolean("onProvisionedOnly")).setProjects(BulkDeleteAction.restrictTo1000Values(request.paramAsStrings("projects"))).setProjectIds(BulkDeleteAction.restrictTo1000Values(request.paramAsStrings("projectIds"))).build();
    }

    @CheckForNull
    private static List<String> restrictTo1000Values(@Nullable List<String> values) {
        if (values == null) {
            return null;
        }
        return values.subList(0, Math.min(values.size(), 1000));
    }
}

